# -*- coding: utf-8 -*-
import httpx
import uuid
import random
import time
import requests
from fastapi import FastAPI, APIRouter, HTTPException, BackgroundTasks
from pydantic import BaseModel
from typing import Optional, Dict, Any, List

from datetime import datetime
import base64
import json
import hashlib
import os
from faker import Faker
import string
import spintax
import csv
import urllib3
import imaplib
import email
import re
import asyncio

import io

# Import instagrapi and supabase for login and saving
try:
    from instagrapi import Client
    from instagrapi.mixins.challenge import ChallengeChoice
    INSTAGRAPI_AVAILABLE = True
except ImportError:
    INSTAGRAPI_AVAILABLE = False
    print("⚠️ instagrapi not available - login functionality will be disabled")

try:
    from supabase import create_client
    from dotenv import load_dotenv
    load_dotenv()
    SUPABASE_URL = os.getenv("SUPABASE_URL")
    SUPABASE_KEY = os.getenv("SUPABASE_KEY")
    if SUPABASE_URL and SUPABASE_KEY:
        supabase = create_client(SUPABASE_URL, SUPABASE_KEY)
        SUPABASE_AVAILABLE = True
        print("✅ Supabase client initialized")
    else:
        supabase = None
        SUPABASE_AVAILABLE = False
        print("⚠️ Supabase credentials not found")
except ImportError:
    supabase = None
    SUPABASE_AVAILABLE = False
    print("⚠️ supabase not available - database saving will be disabled")
except Exception as e:
    supabase = None
    SUPABASE_AVAILABLE = False
    print(f"⚠️ Failed to initialize Supabase: {e}")

# FastAPI app will be created in app.py

# Create router for account creation
router = APIRouter(prefix="/api", tags=["Create Account"])

# Pydantic models for request bodies
class SMSAccountRequest(BaseModel):
    num_accounts: int
    num_threads: int = 3
    use_proxies: bool = False
    country: Optional[str] = "187"  # Country code: 187=USA, 16=United Kingdom, 73=Brazil, 6=Indonesia, 36=Canada
    first_name_variants: Optional[str] = None  # Newline-separated list
    last_name_variants: Optional[str] = None  # Newline-separated list
    username_variants: Optional[str] = None  # Newline-separated list
    bio_variants: Optional[str] = None  # Newline-separated list
    profile_image_url: Optional[str] = None  # Single image URL or newline-separated list of URLs (randomly picked for each account)
    tag: Optional[str] = "cyber scraping"  # Tag for Supabase (default: "cyber scraping")

# Global variables for variants (shared across all account creations)
first_name_list = []
last_name_list = []
username_list = []
bio_list = []
profile_image_url_list = []  # List of image URLs to randomly pick from
tag_global = "cyber scraping"  # Default tag
country_global = "187"  # Default country code (USA)

def parse_variants(variants_string):
    """Parse newline-separated or comma-separated variants into a list"""
    if not variants_string:
        return []
    # First try splitting by newline
    variants = [v.strip() for v in variants_string.split('\n') if v.strip()]
    # If no newlines found, try comma separation
    if len(variants) == 1 and ',' in variants[0]:
        variants = [v.strip() for v in variants_string.split(',') if v.strip()]
    return variants

def get_variant_from_list(variant_list, fallback_func=None):
    """Get a random variant from list, or use fallback function"""
    if variant_list:
        return random.choice(variant_list)
    elif fallback_func:
        return fallback_func()
    return None

def generate_username_from_variant(username_variant):
    """Generate username from variant (without 6-digit suffix)"""
    if not username_variant:
        return None
    # Clean the variant - remove commas, extra spaces, and take only the first part if comma-separated
    cleaned_variant = username_variant.strip()
    # If it contains commas, take only the first variant
    if ',' in cleaned_variant:
        cleaned_variant = cleaned_variant.split(',')[0].strip()
    # Remove any underscores at the end
    cleaned_variant = cleaned_variant.rstrip('_')
    # Ensure it's not too long (Instagram max is 30 chars)
    max_base_length = 30
    if len(cleaned_variant) > max_base_length:
        cleaned_variant = cleaned_variant[:max_base_length]
    # Return username without 6-digit suffix
    return cleaned_variant

# Disable SSL warnings
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

print('                Instagram Account Creator\n')

# # SMS-Activate API Configuration
# SMS_API_KEY = "cd68f36e0de6db7ec06693fe03df2A4c"

SMS_API_KEY = "c1efff7e215460e78fd7135d59fBf0d5"
SMS_API_URL = "https://api.sms-activate.ae/stubs/handler_api.php"


EMAIL_PASSWORD = "Heritech@098A!2"
IMAP_HOST = "scalingtothemoon.com"
IMAP_PORT = 993
EMAIL_CSV_FILE = "email_scalingtothemoon_com.csv"
USED_EMAIL_FILE = "used_email.csv"

# Proxy configuration - load from proxies.txt file
PROXIES_TXT = os.path.join(os.path.dirname(os.path.dirname(__file__)), "proxies.txt")
_proxies_cache = None

def load_proxies_from_file() -> List[str]:
    """
    Load proxies from proxies.txt file.
    Each line should contain one proxy in format: scheme://user:pass@host:port
    Returns empty list if file doesn't exist or is empty.
    """
    global _proxies_cache
    
    # Return cached proxies if available
    if _proxies_cache is not None:
        return _proxies_cache
    
    proxies = []
    if os.path.exists(PROXIES_TXT):
        try:
            with open(PROXIES_TXT, 'r', encoding='utf-8') as f:
                for line in f:
                    line = line.strip()
                    # Skip empty lines and comments
                    if line and not line.startswith('#'):
                        proxies.append(line)
            print(f"✅ Loaded {len(proxies)} proxies from {PROXIES_TXT}")
        except Exception as e:
            print(f"Error loading proxies from {PROXIES_TXT}: {e}")
    else:
        print(f"⚠️ Proxies file not found: {PROXIES_TXT}")
    
    # Cache the proxies
    _proxies_cache = proxies
    return proxies

# Load proxies from file
PROXIES = load_proxies_from_file()

def get_random_proxy() -> Optional[str]:
    """
    Get a random proxy from proxies.txt file.
    Returns None if no proxies are available.
    Ensures proxy has proper scheme (http:// or https://).
    """
    global PROXIES, _proxies_cache
    
    # Reload proxies if cache is empty (in case file was updated)
    if not PROXIES:
        _proxies_cache = None
        PROXIES = load_proxies_from_file()
    
    if PROXIES:
        proxy = random.choice(PROXIES)
        # Ensure proxy has scheme
        if proxy and not proxy.startswith(('http://', 'https://', 'socks5://', 'socks4://')):
            # Add http:// if no scheme
            proxy = f"http://{proxy}"
        return proxy
    return None

# Country code to proxy keyword mapping
COUNTRY_TO_PROXY_KEYWORD = {
    "187": "us",   # USA
    "16": "uk",    # United Kingdom
    "73": "br",    # Brazil
    "6": "id",     # Indonesia
    "36": "ca"     # Canada
}

# Country code to country name mapping
COUNTRY_CODE_TO_NAME = {
    "187": "USA",
    "16": "United Kingdom",
    "73": "Brazil",
    "6": "Indonesia",
    "36": "Canada"
}

# Global variables
proxies = None
use_proxies = False
max_threads = 3
current_proxy_index = 0  # Track current proxy for rotation (each account gets its own proxy)
MAX_THREADS = 10  # Hard cap for threads
proxy_lock = asyncio.Lock()  # Thread-safe proxy rotation lock
current_session_token = None  # Authorization token from successful account creation

# Phone number pool for reuse
phone_pool_lock = asyncio.Lock()
phone_pool = []  # Pool of available phone numbers: [{"activation_id": ..., "phone_number": ..., "accounts_used": ...}, ...]
phones_per_task = {}  # Track phone assigned to each task: {task_id: {"activation_id": ..., "phone_number": ..., "accounts_count": ...}}
phone_locks = {}  # Locks per phone to ensure sequential processing: {phone_number: asyncio.Lock()}
phones_lock = asyncio.Lock()  # Lock for phone_locks dict

# Global proxy for current operation (replaces thread-local storage)
current_proxy = None

async def get_next_proxy():
    """Get a random proxy - each account gets its own randomly selected proxy"""
    global current_proxy_index, proxies, country_global
    async with proxy_lock:
        if use_proxies and PROXIES:
            # Randomly select a proxy instead of rotation
            current_index = random.randint(0, len(PROXIES) - 1)
            
            # Get the proxy string for this account
            proxy_string = PROXIES[current_index]
            proxy_num = current_index + 1  # Display as 1-indexed
            
            # Replace country keyword in proxy string based on country_global
            # Proxy format: "username:type;country;;;@host:port" (e.g., "xdILoVU6u1Jj0LRM:wifi;us;;;@proxy.soax.com:9000")
            # Replace the country keyword (e.g., "us" -> "uk", "br", etc.)
            if country_global in COUNTRY_TO_PROXY_KEYWORD:
                proxy_keyword = COUNTRY_TO_PROXY_KEYWORD[country_global]
                # Replace country keyword in proxy string
                # Pattern matches: ;us;;; or ;uk;;; etc. and replaces the country code
                import re
                proxy_string = re.sub(r';(us|uk|br|id|ca);', f';{proxy_keyword};', proxy_string)
            
            # Parse proxy format: username:password@host:port or username@host:port
            if '@' in proxy_string:
                auth_part, host_part = proxy_string.split('@')
                host, port = host_part.split(':')
                
                # Check if auth_part has password (contains :)
                if ':' in auth_part:
                    username, password = auth_part.split(':', 1)
                    proxy_url = f'http://{username}:{password}@{host}:{port}'
                else:
                    # No password, just username
                    username = auth_part
                    proxy_url = f'http://{username}@{host}:{port}'
                
                global current_proxy
                current_proxy = {
                    'http': proxy_url,
                    'https': proxy_url
                }
                print(f"🌐 Using proxy #{proxy_num}: {proxy_url}")
                return proxy_num  # Return proxy number for logging
            else:
                current_proxy = None
                return None
        else:
            current_proxy = None
            return None

def get_proxy():
    """Get a random proxy from the list"""
    global proxies, country_global
    if use_proxies and PROXIES:
        proxy_string = random.choice(PROXIES)
        
        # Replace country keyword in proxy string based on country_global
        # Proxy format: "username:type;country;;;@host:port" (e.g., "xdILoVU6u1Jj0LRM:wifi;us;;;@proxy.soax.com:9000")
        if country_global in COUNTRY_TO_PROXY_KEYWORD:
            proxy_keyword = COUNTRY_TO_PROXY_KEYWORD[country_global]
            # Replace country keyword in proxy string
            import re
            proxy_string = re.sub(r';(us|uk|br|id|ca);', f';{proxy_keyword};', proxy_string)
        
        print(f"🔍 Selected proxy string: '{proxy_string}'")
        
        # Parse proxy format: username:password@host:port or username@host:port
        if '@' in proxy_string:
            auth_part, host_part = proxy_string.split('@')
            host, port = host_part.split(':')
            
            print(f"🔍 Debug - auth_part: '{auth_part}', host_part: '{host_part}'")
            
            # Check if auth_part has password (contains :)
            if ':' in auth_part:
                username, password = auth_part.split(':', 1)
                proxy_url = f'http://{username}:{password}@{host}:{port}'
                print(f"🌐 Using proxy: {username}@{host}:{port} (with password: {password})")
                print(f"🔍 Full proxy URL: {proxy_url}")
            else:
                # No password, just username
                username = auth_part
                proxy_url = f'http://{username}@{host}:{port}'
                print(f"🌐 Using proxy: {username}@{host}:{port} (no password)")
                print(f"🔍 Full proxy URL: {proxy_url}")
            
            proxies = {
                'http': proxy_url,
                'https': proxy_url
            }
        else:
            proxies = None
            print("🌐 Using direct connection (no proxy)")
    else:
        proxies = None
        print("🌐 Using direct connection (no proxy)")

def get_proxy_with_ssl_fix():
    """Get proxy with SSL verification disabled"""
    global proxies
    if PROXIES:
        proxy_string = random.choice(PROXIES)
        # Parse proxy format: username:password@host:port or username@host:port
        if '@' in proxy_string:
            auth_part, host_part = proxy_string.split('@')
            host, port = host_part.split(':')
            
            # Check if auth_part has password (contains :)
            if ':' in auth_part:
                username, password = auth_part.split(':', 1)
                proxy_url = f'http://{username}:{password}@{host}:{port}'
                print(f"🌐 Using proxy: {username}@{host}:{port}")
            else:
                # No password, just username
                username = auth_part
                proxy_url = f'http://{username}@{host}:{port}'
                print(f"🌐 Using proxy: {username}@{host}:{port}")
            
            proxies = {
                'http': proxy_url,
                'https': proxy_url
            }
        else:
            proxies = None
            print("🌐 Using direct connection (no proxy)")
    else:
        proxies = None
        print("🌐 Using direct connection (no proxy)")

def get_current_ip():
    """Get current IP address"""
    try:
        global current_proxy
        response = requests.get('https://api.ipify.org', proxies=current_proxy, timeout=10, verify=False)
        if response.status_code == 200:
            return response.text.strip()
        else:
            return "Unknown"
    except Exception as e:
        return "Unknown"

def extract_proxy_country(proxy_string: Optional[str]) -> Optional[str]:
    """Extract country from proxy string and map to full country name
    
    Maps:
    - us/usa -> united states of america
    - uk -> united kingdom
    - br -> brazil
    - ng -> nigeria
    - Other country codes -> full country name
    """
    if not proxy_string:
        return None
    
    proxy_lower = proxy_string.lower()
    
    # Country code mappings
    country_mappings = {
        'us': 'united states of america',
        'usa': 'united states of america',
        'uk': 'united kingdom',
        'gb': 'united kingdom',
        'br': 'brazil',
        'ng': 'nigeria',
        'ca': 'canada',
        'au': 'australia',
        'de': 'germany',
        'fr': 'france',
        'it': 'italy',
        'es': 'spain',
        'nl': 'netherlands',
        'pl': 'poland',
        'mx': 'mexico',
        'in': 'india',
        'jp': 'japan',
        'kr': 'south korea',
        'cn': 'china',
        'ru': 'russia',
    }
    
    # Check for country codes in proxy string
    for code, country_name in country_mappings.items():
        # Check if country code appears in proxy string (as separate word or part of hostname)
        if f'.{code}.' in proxy_lower or f'-{code}.' in proxy_lower or f'_{code}.' in proxy_lower or f'/{code}/' in proxy_lower:
            return country_name
        # Also check if it's at the end (e.g., proxy-us.example.com)
        if proxy_lower.endswith(f'.{code}') or proxy_lower.endswith(f'-{code}'):
            return country_name
    
    # If no country code found, try to extract from common patterns
    # Some proxies have format like: username:pass@proxy-us.example.com:port
    # or username:pass@us.proxy.example.com:port
    import re
    # Look for 2-letter country codes
    country_code_match = re.search(r'[._-]([a-z]{2})[._-]', proxy_lower)
    if country_code_match:
        code = country_code_match.group(1)
        if code in country_mappings:
            return country_mappings[code]
    
    return None

def test_proxy_connection():
    """Test proxy connection with SSL verification disabled - more lenient"""
    global current_proxy
    p = current_proxy
    if not p:
        print("🌐 Direct connection (no proxy)")
        return True
    
    try:
        # Try a simple test with a more lenient approach
        response = requests.get('https://api.ipify.org', proxies=p, timeout=10, verify=False)
        if response.status_code == 200:
            ip = response.text.strip()
            print(f"✅ Proxy connection successful: {ip}")
            return True
        elif response.status_code == 503:
            # 503 might be temporary, but proxy could still work for Instagram
            print(f"⚠️ Proxy test returned 503 (service unavailable), but continuing...")
            return True
        else:
            print(f"❌ Proxy connection failed: HTTP {response.status_code}")
            return False
    except Exception as e:
        print(f"⚠️ Proxy connection test failed: {e}, but continuing...")
        # Don't fail on proxy test errors, let Instagram requests determine if proxy works
        return True

# Functions
def generate_uuid(prefix: str = '', suffix: str = '') -> str:
    return f'{prefix}{uuid.uuid4()}{suffix}'

def generate_android_device_id() -> str:
    return "android-%s" % hashlib.sha256(str(time.time()).encode()).hexdigest()[:16]

def generate_useragent():
    try:
        with open("UserAgent.txt", "r") as file:
            agents = file.read().splitlines()
            a = random.choice(agents)
            user = a.split(",")
            user_agent = f'Instagram 350.0.0.28.96 Android ({user[7]}/{user[6]}; {user[5]}dpi; {user[4]}; {user[0]}; {user[1]}; {user[2]}; {user[3]}; en_US; {user[9]})'
            print(f"🎭 Selected User Agent: {user[0]} {user[1]} ({user[4]})")
            return user_agent
    except FileNotFoundError:
        # Fallback user agent if file not found
        print("⚠️ UserAgent.txt not found, using fallback")
        return 'Instagram 350.0.0.28.96 Android (28/9; 420dpi; 1080x1920; samsung; SM-G975F; beyond2; exynos9820; en_US; 314665256)'

def get_mid():
    try:
        params = None
        api_url = f"https://i.instagram.com/api/v1/accounts/login"
        global current_proxy
        response = requests.get(api_url, params=params, proxies=current_proxy, timeout=30, verify=False)
        mid = response.cookies.get("mid")
        if mid != None:
            return mid
        else:
            u01 = 'QWERTYUIOPASDFGHJKLZXCVBNM'
            us1 = str("".join(random.choice(u01)for k in range(int(8))))
            return f'Y4nS4g{us1}zwIrWdeYLcD9Shxj'
    except Exception as e:
        print(f"Error getting MID: {e}")
        u01 = 'QWERTYUIOPASDFGHJKLZXCVBNM'
        us1 = str("".join(random.choice(u01)for k in range(int(8))))
        return f'Y4nS4g{us1}zwIrWdeYLcD9Shxj'

def Username():
    fake = Faker()
    name = fake.name()
    return str(name)

def generate_random_username():
    """Generate a random username: name (without 6-digit suffix)"""
    try:
        # Import names module
        import names
        
        # Get random first and last name for username
        first_name = names.get_first_name().lower()
        last_name = names.get_last_name().lower()
        
        # Create username: firstname + lastname (max 30 chars, no numbers)
        username = f"{first_name}{last_name}"
        
        # Ensure it's under 30 characters
        if len(username) > 30:
            # If too long, use just first name
            username = first_name[:30]
        
        return username
        
    except ImportError:
        # Fallback if names module not available
        fake = Faker()
        first_name = fake.first_name().lower()
        username = first_name
        
        # Ensure it's under 30 characters
        if len(username) > 30:
            username = first_name[:30]
        
        return username


def generate_real_name():
    """Generate a real name for the name field (no numbers)"""
    try:
        # Import names module
        import names
        
        # Get random first and last name
        first_name = names.get_first_name()
        last_name = names.get_last_name()
        
        # Return full name without numbers
        return f"{first_name} {last_name}"
        
    except ImportError:
        # Fallback if names module not available
        fake = Faker()
        return fake.name()

def Password():
    lower = string.ascii_lowercase
    upper = string.ascii_uppercase
    num = string.digits
    symbols = string.punctuation
    all = lower + upper + num + symbols
    temp = random.sample(all, 9)
    password = "".join(temp)
    return password

def generate_jazoest(symbols: str) -> str:
    amount = sum(ord(s) for s in symbols)
    return f'2{amount}'

def Birthday():
    day = str(random.randint(1, 28))
    month = str(random.randint(1, 12))
    year = str(random.randint(1988, 2003))
    birth = [day, year, month]
    return birth

def DP():
    directory = r'Data/DP/'
    if os.path.exists(directory):
        files = os.listdir(directory)
        if files:
            random_file = random.choice(files)
            file_path = os.path.join(directory, random_file)
            return file_path
    return None

def Posts():
    posts = []
    directory = r'Data/Posts/'
    if os.path.exists(directory):
        files = os.listdir(directory)
        if files:
            for i in range(3):
                random_file = random.choice(files)
                file_path = os.path.join(directory, random_file)
                posts.append(file_path)
    return posts

def read_emails_from_csv():
    """Read emails from CSV file (from v.py)"""
    emails = []
    try:
        with open(EMAIL_CSV_FILE, 'r') as file:
            csv_reader = csv.reader(file)
            for row in csv_reader:
                if row and row[0].strip():
                    # Clean the email (remove quotes and extra characters)
                    email = row[0].strip().replace('"', '').replace("'", "")
                    if '@' in email:
                        emails.append(email)
        return emails
    except Exception as e:
        print(f"Error reading CSV: {e}")
        return []

def get_verification_code_for_challenge(email_address, password, max_wait=60, min_timestamp=None):
    """Get verification code from email for challenge (more aggressive polling)
    
    Args:
        email_address: Email address to check
        password: Email password
        max_wait: Maximum time to wait in seconds
        min_timestamp: Only look for emails that arrived AFTER this timestamp (to avoid old emails)
    """
    import time
    import signal
    import email.utils
    
    start_time = time.time()
    poll_interval = 3  # Check every 3 seconds
    max_attempts = max_wait // poll_interval
    
    # Convert min_timestamp to email date format if provided
    min_email_date = None
    if min_timestamp:
        # Convert timestamp to email date format (e.g., "01-Jan-2024")
        min_email_date = time.strftime('%d-%b-%Y', time.localtime(min_timestamp))
    
    for attempt in range(max_attempts):
        elapsed = time.time() - start_time
        if elapsed >= max_wait:
            break
            
        try:
            # Connect to IMAP server with timeout
            mail = None
            try:
                # Set socket timeout for IMAP operations (10 seconds per operation)
                mail = imaplib.IMAP4_SSL(IMAP_HOST, IMAP_PORT, timeout=10)
            except Exception as conn_error:
                print(f"[DEBUG] ⚠️ IMAP connection error: {conn_error}")
                time.sleep(poll_interval)
                continue
            
            # Login with timeout protection
            try:
                mail.login(email_address, password)
            except Exception:
                try:
                    mail.login(email_address.split('@')[0], password)
                except Exception:
                    try:
                        mail.close()
                        mail.logout()
                    except:
                        pass
                    time.sleep(poll_interval)
                    continue
            
            try:
                mail.select('inbox')
            except Exception as select_error:
                print(f"[DEBUG] ⚠️ IMAP select error: {select_error}")
                try:
                    mail.close()
                    mail.logout()
                except:
                    pass
                time.sleep(poll_interval)
                continue
            
            # Search for UNSEEN emails from Instagram (with timeout)
            try:
                status, messages = mail.search(None, '(UNSEEN FROM "instagram.com" OR UNSEEN FROM "mail.instagram.com")')
            except Exception as search_error:
                print(f"[DEBUG] ⚠️ IMAP search error: {search_error}")
                try:
                    mail.close()
                    mail.logout()
                except:
                    pass
                time.sleep(poll_interval)
                continue
            
            # If no UNSEEN, try RECENT emails from last 5 minutes (or since min_timestamp if provided)
            if status != 'OK' or not messages[0]:
                try:
                    import datetime
                    if min_email_date:
                        # Use min_email_date (challenge start time) to only get emails after challenge started
                        since_date = min_email_date
                    else:
                        # Default: last 5 minutes
                        since_date = (datetime.datetime.now() - datetime.timedelta(minutes=5)).strftime('%d-%b-%Y')
                    status, messages = mail.search(None, f'(SINCE {since_date} FROM "instagram.com" OR SINCE {since_date} FROM "mail.instagram.com")')
                except Exception as search_error:
                    print(f"[DEBUG] ⚠️ IMAP search error: {search_error}")
                    try:
                        mail.close()
                        mail.logout()
                    except:
                        pass
                    time.sleep(poll_interval)
                    continue
            
            if status == 'OK' and messages[0]:
                message_ids = messages[0].split()
                message_ids.reverse()  # Newest first
                
                for msg_id in message_ids:
                    try:
                        status, msg_data = mail.fetch(msg_id, '(RFC822)')
                    except Exception as fetch_error:
                        print(f"[DEBUG] ⚠️ IMAP fetch error: {fetch_error}")
                        continue
                    
                    if status == 'OK':
                        email_body = msg_data[0][1]
                        email_message = email.message_from_bytes(email_body)
                        
                        # Check if email arrived after min_timestamp (if provided)
                        if min_timestamp:
                            try:
                                # Get email date from header
                                email_date_str = email_message.get('Date', '')
                                if email_date_str:
                                    # Parse email date to timestamp
                                    email_date_tuple = email.utils.parsedate_tz(email_date_str)
                                    if email_date_tuple:
                                        email_timestamp = email.utils.mktime_tz(email_date_tuple)
                                        # Only process emails that arrived AFTER challenge started
                                        if email_timestamp < min_timestamp:
                                            # This email is too old (from before challenge), skip it
                                            continue
                            except Exception as date_error:
                                # If we can't parse date, include it anyway (better to check than skip)
                                pass
                        
                        sender = email_message.get('From', '').lower()
                        if 'instagram.com' in sender or 'mail.instagram.com' in sender:
                            # Extract code from email
                            code = None
                            body_html = ""
                            body_text = ""
                            
                            if email_message.is_multipart():
                                for part in email_message.walk():
                                    content_type = part.get_content_type()
                                    if content_type == "text/html":
                                        try:
                                            body_html = part.get_payload(decode=True).decode('utf-8', errors='ignore')
                                        except:
                                            pass
                                    elif content_type == "text/plain":
                                        try:
                                            body_text = part.get_payload(decode=True).decode('utf-8', errors='ignore')
                                        except:
                                            pass
                            else:
                                try:
                                    body_text = email_message.get_payload(decode=True).decode('utf-8', errors='ignore')
                                except:
                                    pass
                            
                            # Search for 6-digit code - avoid matching color codes like #262626
                            if body_html:
                                # Look for codes in large font-size spans (Instagram verification codes are usually 28px)
                                # Pattern: font-size: 28px or similar large sizes, then the code
                                patterns = [
                                    r'font-size:\s*28px[^>]*>(\d{6})<',  # Large font-size with code
                                    r'text-align:\s*center[^>]*>(\d{6})<',  # Centered text with code
                                    r'<span[^>]*>(\d{6})</span>',  # Code in span (but not color codes)
                                    r'>(\d{6})<',  # Code between > and < (but exclude if preceded by #)
                                ]
                                
                                for pattern in patterns:
                                    matches = re.finditer(pattern, body_html, re.IGNORECASE)
                                    for match in matches:
                                        potential_code = match.group(1)
                                        # Check if it's not a color code (avoid #262626, #262626, etc.)
                                        # Check context before the match to see if it's a color
                                        start_pos = match.start()
                                        context_before = body_html[max(0, start_pos-10):start_pos]
                                        # If preceded by # or color:, skip it
                                        if not re.search(r'[#:]262626|color[:\s]*#?\d{6}', context_before, re.IGNORECASE):
                                            code = potential_code
                                            break
                                    if code:
                                        break
                            
                            if not code and body_text:
                                # In plain text, look for standalone 6-digit codes (not part of colors)
                                # Pattern: word boundary, 6 digits, word boundary (but not #262626)
                                code_match = re.search(r'(?<!#)\b(\d{6})\b(?!\d)', body_text)
                                if code_match:
                                    code = code_match.group(1)
                            
                            if code:
                                try:
                                    mail.store(msg_id, '+FLAGS', '\\Seen')
                                    mail.close()
                                    mail.logout()
                                except:
                                    pass
                                print(f"✅ Challenge code found: {code} (after {elapsed:.1f}s)")
                                return code
                            
            try:
                mail.close()
                mail.logout()
            except:
                pass
            
        except Exception as e:
            print(f"[DEBUG] ⚠️ Error checking email (attempt {attempt + 1}): {e}")
            try:
                if 'mail' in locals():
                    mail.close()
                    mail.logout()
            except:
                pass
        
        # Wait before next check
        if attempt < max_attempts - 1:
            time.sleep(poll_interval)
    
    print(f"[DEBUG] ❌ No challenge code found after {max_wait} seconds")
    return None

def get_verification_code(email_address, password, max_wait=120):
    """Get verification code from email with retry logic (from v.py)"""
    max_retries = 6
    retry_delay = 10  # 10 seconds like Node.js version
    start_time = time.time()
    
    for attempt in range(max_retries):
        # Check overall timeout
        if time.time() - start_time > max_wait:
            print(f"[DEBUG] ❌ Email verification timeout after {max_wait}s")
            return None
            
        try:
            # Connect to IMAP server with timeout
            mail = imaplib.IMAP4_SSL(IMAP_HOST, IMAP_PORT, timeout=15)
            
            # Try login with string format (IMAP library handles encoding internally)
            print(f"🔐 Attempting IMAP login for {email_address}...")
            login_successful = False
            
            try:
                # Try different login formats (some IMAP servers need full email, others need username)
                login_methods = [
                    (email_address, "full email address"),
                    (email_address.split('@')[0] if '@' in email_address else email_address, "username only"),
                ]
                
                for login_user, method_name in login_methods:
                    try:
                        print(f"   Trying login method: {method_name} ({login_user})")
                        # Use string format for login (imaplib handles encoding)
                        mail.login(login_user, password)
                        print(f"✅ IMAP login successful using {method_name} ({login_user})")
                        login_successful = True
                        break
                    except imaplib.IMAP4.error as method_error:
                        print(f"   Login failed with {method_name}: {method_error}")
                        continue
                    except Exception as method_error:
                        print(f"   Unexpected error with {method_name}: {method_error}")
                        continue
                
                if not login_successful:
                    raise imaplib.IMAP4.error("All login methods failed")
                    
            except imaplib.IMAP4.error as login_error:
                error_msg = str(login_error)
                print(f"❌ IMAP login failed: {error_msg}")
                
                # Check if it's an authentication error
                if 'LOGIN' in error_msg or 'AUTHENTICATE' in error_msg or 'BAD' in error_msg:
                    print(f"🔍 Authentication error detected. Checking credentials...")
                    print(f"   Email: {email_address}")
                    print(f"   Password length: {len(password)} characters")
                    print(f"   Password starts with: {password[:3]}...")
                    
                    # If password contains special characters, they might need escaping
                    if '@' in password or '!' in password or '#' in password:
                        print(f"⚠️ Password contains special characters - ensure it's correct")
                    
                    # Close connection if login failed
                    try:
                        mail.logout()
                    except:
                        pass
                    
                    if attempt < max_retries - 1:
                        print(f"⏳ Retrying in {retry_delay} seconds...")
                        time.sleep(retry_delay)
                        continue
                    else:
                        print(f"❌ Failed to login after {max_retries} attempts. Please verify:")
                        print(f"   1. Email address is correct: {email_address}")
                        print(f"   2. Password is correct: {EMAIL_PASSWORD if password == EMAIL_PASSWORD else 'Different password used'}")
                        print(f"   3. IMAP server is accessible: {IMAP_HOST}:{IMAP_PORT}")
                        raise login_error
                else:
                    # Other IMAP errors, just retry
                    try:
                        mail.logout()
                    except:
                        pass
                    if attempt < max_retries - 1:
                        print(f"⏳ Retrying in {retry_delay} seconds...")
                        time.sleep(retry_delay)
                        continue
                    raise login_error
            except Exception as login_error:
                error_msg = str(login_error)
                print(f"❌ Unexpected IMAP error: {error_msg}")
                try:
                    mail.logout()
                except:
                    pass
                if attempt < max_retries - 1:
                    print(f"⏳ Retrying in {retry_delay} seconds...")
                    time.sleep(retry_delay)
                    continue
                raise login_error
            
            try:
                mail.select('inbox')
            except Exception as select_error:
                print(f"[DEBUG] ⚠️ IMAP select error: {select_error}")
                try:
                    mail.logout()
                except:
                    pass
                if attempt < max_retries - 1:
                    time.sleep(retry_delay)
                    continue
                return None
            
            # Search for emails from Instagram - check both UNSEEN and RECENT (last 10 minutes)
            # Instagram challenge emails can have various subjects, so we search by sender
            # First try UNSEEN emails from Instagram
            try:
                status, messages = mail.search(None, '(UNSEEN FROM "instagram.com" OR UNSEEN FROM "mail.instagram.com")')
            except Exception as search_error:
                print(f"[DEBUG] ⚠️ IMAP search error: {search_error}")
                try:
                    mail.logout()
                except:
                    pass
                if attempt < max_retries - 1:
                    time.sleep(retry_delay)
                    continue
                return None
            
            # If no UNSEEN, try RECENT emails from last 10 minutes
            if status != 'OK' or not messages[0]:
                try:
                    # Search for recent emails (last 10 minutes)
                    import datetime
                    since_date = (datetime.datetime.now() - datetime.timedelta(minutes=10)).strftime('%d-%b-%Y')
                    status, messages = mail.search(None, f'(SINCE {since_date} FROM "instagram.com" OR SINCE {since_date} FROM "mail.instagram.com")')
                except Exception as search_error:
                    print(f"[DEBUG] ⚠️ IMAP search error: {search_error}")
                    try:
                        mail.logout()
                    except:
                        pass
                    if attempt < max_retries - 1:
                        time.sleep(retry_delay)
                        continue
                    return None
            
            if status == 'OK' and messages[0]:
                # Get all message IDs and sort them (newest first)
                message_ids = messages[0].split()
                message_ids.reverse()  # Newest first
                
                for msg_id in message_ids:
                    # Fetch the email with timeout protection
                    try:
                        status, msg_data = mail.fetch(msg_id, '(RFC822)')
                    except Exception as fetch_error:
                        print(f"[DEBUG] ⚠️ IMAP fetch error: {fetch_error}")
                        continue
                    
                    if status == 'OK':
                        email_body = msg_data[0][1]
                        email_message = email.message_from_bytes(email_body)
                        
                        # Check sender and subject
                        sender = email_message.get('From', '')
                        subject = email_message.get('Subject', '')
                        
                        
                        # Look for any email from Instagram (challenge emails can have various subjects)
                        is_instagram_email = (
                            'instagram.com' in sender.lower() or 
                            'mail.instagram.com' in sender.lower() or
                            'no-reply@mail.instagram.com' in sender.lower() or
                            'security@mail.instagram.com' in sender.lower()
                        )
                        
                        if is_instagram_email:
                            print(f"✅ Found Instagram email!")
                            
                            # Extract verification code from email body
                            code = None
                            
                            # Get email body content
                            body_text = ""
                            body_html = ""
                            
                            if email_message.is_multipart():
                                for part in email_message.walk():
                                    content_type = part.get_content_type()
                                    if content_type == "text/html":
                                        try:
                                            body_html = part.get_payload(decode=True).decode('utf-8', errors='ignore')
                                        except:
                                            pass
                                    elif content_type == "text/plain":
                                        try:
                                            body_text = part.get_payload(decode=True).decode('utf-8', errors='ignore')
                                        except:
                                            pass
                            else:
                                # Single part message
                                try:
                                    body_text = email_message.get_payload(decode=True).decode('utf-8', errors='ignore')
                                except:
                                    pass
                            
                            # Search for 6-digit code OR confirmation token/link in HTML first
                            if body_html:
                                # First, try to find confirmation token/link (for "Confirm your email address" emails)
                                confirmation_patterns = [
                                    r'confirm_email/([A-Za-z0-9_-]+)',  # confirm_email/TOKEN (Instagram format)
                                    r'confirm_email/([A-Za-z0-9_-]+)/',  # confirm_email/TOKEN/ (with trailing slash)
                                    r'confirmation_token[=:](\w+)',  # confirmation_token=ABC123
                                    r'confirm[^>]*href=["\']([^"\']*)["\']',  # href in confirm button/link
                                    r'https?://[^"\'>\s]*confirmation[^"\'>\s]*token[=:](\w+)',  # URL with token
                                    r'https?://[^"\'>\s]*token[=:](\w+)',  # URL with token parameter
                                    r'https?://[^"\'>\s]*\?[^"\'>\s]*token[=:](\w+)',  # URL query parameter token
                                    r'confirm[^>]*token[=:](\w+)',  # confirm...token=ABC123
                                ]
                                
                                confirmation_token = None
                                for pattern in confirmation_patterns:
                                    matches = re.finditer(pattern, body_html, re.IGNORECASE)
                                    for match in matches:
                                        potential_token = match.group(1) if match.groups() else match.group(0)
                                        
                                        # Special handling for confirm_email/TOKEN pattern (Instagram format)
                                        if 'confirm_email' in pattern:
                                            # Token is already extracted by the regex pattern
                                            if potential_token and len(potential_token) >= 8 and len(potential_token) < 200:
                                                confirmation_token = potential_token
                                                print(f"[DEBUG] ✅ Found confirmation token from confirm_email link: {confirmation_token[:30]}...")
                                                break
                                            continue
                                        
                                        # Extract token from URL if it's a full URL
                                        if 'http' in potential_token or '?' in potential_token:
                                            # First try to extract from confirm_email/TOKEN format in URL
                                            confirm_email_match = re.search(r'confirm_email/([A-Za-z0-9_-]+)', potential_token, re.IGNORECASE)
                                            if confirm_email_match:
                                                potential_token = confirm_email_match.group(1)
                                                if len(potential_token) >= 8 and len(potential_token) < 200:
                                                    confirmation_token = potential_token
                                                    print(f"[DEBUG] ✅ Found confirmation token from URL path: {confirmation_token[:30]}...")
                                                    break
                                            
                                            # Extract token from URL parameters (multiple formats)
                                            token_matches = [
                                                r'token[=:](\w+)',  # token=ABC123
                                                r'confirmation_token[=:](\w+)',  # confirmation_token=ABC123
                                                r'c[=:](\w+)',  # c=ABC123 (short form)
                                                r'code[=:](\w+)',  # code=ABC123
                                            ]
                                            for token_pattern in token_matches:
                                                token_match = re.search(token_pattern, potential_token, re.IGNORECASE)
                                                if token_match:
                                                    potential_token = token_match.group(1)
                                                    break
                                            # If still a URL, try to extract from path or query
                                            if 'http' in potential_token or len(potential_token) > 200:
                                                # Try to extract from URL path segments
                                                url_parts = potential_token.split('/')
                                                for part in url_parts:
                                                    if len(part) >= 8 and len(part) < 200 and not 'http' in part and not 'instagram' in part.lower():
                                                        potential_token = part.split('?')[0].split('&')[0]
                                                        break
                                        
                                        # Validate token length (Instagram tokens are usually 8+ characters)
                                        if potential_token and len(potential_token) >= 8 and len(potential_token) < 200:
                                            confirmation_token = potential_token
                                            print(f"[DEBUG] ✅ Found confirmation token in HTML: {confirmation_token[:30]}...")
                                            break
                                    if confirmation_token:
                                        break
                                
                                # If we found a confirmation token, use it
                                if confirmation_token:
                                    code = confirmation_token
                                else:
                                    # Look for 6-digit codes in large font-size spans (Instagram verification codes are usually 28px)
                                    patterns = [
                                        r'font-size:\s*28px[^>]*>(\d{6})<',  # Large font-size with code
                                        r'text-align:\s*center[^>]*>(\d{6})<',  # Centered text with code
                                        r'<span[^>]*>(\d{6})</span>',  # Code in span
                                        r'code[:\s]*(\d{6})',  # "code: 123456"
                                        r'verification[:\s]*code[:\s]*(\d{6})',  # "verification code: 123456"
                                        r'>(\d{6})<',  # Code between > and < (but exclude if preceded by #)
                                    ]
                                    
                                    for pattern in patterns:
                                        matches = re.finditer(pattern, body_html, re.IGNORECASE)
                                        for match in matches:
                                            potential_code = match.group(1)
                                            # Check if it's not a color code (avoid #262626)
                                            start_pos = match.start()
                                            context_before = body_html[max(0, start_pos-10):start_pos]
                                            # If preceded by # or color:, skip it
                                            if not re.search(r'[#:]262626|color[:\s]*#?\d{6}', context_before, re.IGNORECASE):
                                                code = potential_code
                                                print(f"[DEBUG] ✅ Found code in HTML: {code}")
                                                break
                                        if code:
                                            break
                            
                            # If not found in HTML, try plain text
                            if not code and body_text:
                                # First try confirmation token from confirm_email/TOKEN format
                                confirm_email_match = re.search(r'confirm_email/([A-Za-z0-9_-]+)', body_text, re.IGNORECASE)
                                if confirm_email_match:
                                    code = confirm_email_match.group(1)
                                    print(f"[DEBUG] ✅ Found confirmation token from confirm_email link in text: {code[:30]}...")
                                else:
                                    # Try other confirmation token patterns
                                    token_match = re.search(r'confirmation[_\s]*token[=:](\w+)', body_text, re.IGNORECASE)
                                    if token_match:
                                        code = token_match.group(1)
                                        print(f"[DEBUG] ✅ Found confirmation token in text: {code[:20]}...")
                                    else:
                                        # Look for standalone 6-digit codes (not part of colors)
                                        code_match = re.search(r'(?<!#)\b(\d{6})\b(?!\d)', body_text)
                                        if code_match:
                                            code = code_match.group(1)
                                            print(f"[DEBUG] ✅ Found code in text: {code}")
                                        else:
                                            # Try patterns with context
                                            patterns = [
                                                r'code[:\s]*(\d{6})',  # "code: 123456"
                                                r'verification[:\s]*code[:\s]*(\d{6})',  # "verification code: 123456"
                                            ]
                                            for pattern in patterns:
                                                code_match = re.search(pattern, body_text, re.IGNORECASE)
                                                if code_match:
                                                    code = code_match.group(1)
                                                    print(f"[DEBUG] ✅ Found code in text: {code}")
                                                    break
                            
                            if code:
                                # Mark email as read (don't delete, in case we need it)
                                try:
                                    mail.store(msg_id, '+FLAGS', '\\Seen')
                                    print(f"✅ Marked verification email as read")
                                except Exception as mark_error:
                                    print(f"⚠️ Could not mark email as read: {mark_error}")
                                
                                mail.close()
                                mail.logout()
                                print(f"✅ Verification code/token found: {code[:20]}..." if len(code) > 20 else f"✅ Verification code found: {code}")
                                return code
                            else:
                                print(f"⚠️ Instagram email found but no 6-digit code or confirmation token detected")
            
            mail.close()
            mail.logout()
            
            if attempt < max_retries - 1:
                time.sleep(retry_delay)
            
        except Exception as e:
            print(f"❌ Error getting verification code (attempt {attempt + 1}): {e}")
            if attempt < max_retries - 1:
                print(f"⏳ Retrying in {retry_delay} seconds...")
                time.sleep(retry_delay)
    
    print(f"❌ Could not retrieve verification code after {max_retries} attempts")
    return None

def move_email_to_used(email_address):
    """Move email to used_emails.csv (from v.py)"""
    try:
        # Read all emails from main CSV
        emails = []
        with open(EMAIL_CSV_FILE, 'r') as file:
            csv_reader = csv.reader(file)
            for row in csv_reader:
                if row and row[0].strip():
                    email = row[0].strip().replace('"', '').replace("'", "")
                    if '@' in email and email != email_address:
                        emails.append(email)
        
        # Write remaining emails back to main CSV
        with open(EMAIL_CSV_FILE, 'w', newline='') as file:
            csv_writer = csv.writer(file)
            for email in emails:
                csv_writer.writerow([email])
        
        # Append used email to used_emails.csv
        with open('used_emails.csv', 'a', newline='') as file:
            csv_writer = csv.writer(file)
            csv_writer.writerow([email_address])
        
        print(f"📧 Moved {email_address} to used_emails.csv")
        return True
        
    except Exception as e:
        print(f"❌ Error moving email to used: {e}")
        return False

def get_available_email():
    """Get an available email from scalingtothemoon_com.csv and move it to used_email.csv"""
    try:
        # Read available emails
        with open(EMAIL_CSV_FILE, 'r', encoding='utf-8') as f:
            available_emails = [line.strip() for line in f.readlines() if line.strip()]
        
        if not available_emails:
            print("❌ No available emails in CSV file!")
            return None
        
        # Pick first available email
        selected_email = available_emails[0]
        print(f"📧 Selected email: {selected_email}")
        
        # Remove selected email from available list
        remaining_emails = available_emails[1:]
        
        # Write remaining emails back to CSV
        with open(EMAIL_CSV_FILE, 'w', encoding='utf-8') as f:
            for email in remaining_emails:
                f.write(email + '\n')
        
        # Add selected email to used emails file
        with open(USED_EMAIL_FILE, 'a', encoding='utf-8') as f:
            f.write(selected_email + '\n')
        
        print(f"✅ Email {selected_email} moved to used list")
        return selected_email
        
    except Exception as e:
        print(f"❌ Error managing email: {e}")
        return None

def add_email_recovery_to_sms_account(username, password, phone_number, recovery_email, session_token=None):
    """Add email recovery to SMS account after creation using real Instagram endpoints
    Uses the account's own session_token to ensure each account uses its own session/cookie
    """
    try:
        print(f"[DEBUG] Adding email recovery: {recovery_email} for account: {username}")
        
        # Create headers with THIS account's session token (not global/shared)
        headers = get_mobile_headers()
        if session_token:
            headers['Authorization'] = session_token
        else:
            print(f"[DEBUG] ⚠️ No session token provided for email recovery")
        
        # Step 1: Send confirmation code to recovery email using Instagram's real endpoint
        print(f"[DEBUG] Step 1: Requesting confirmation code to {recovery_email}...")
        data = {
            'signed_body': f'SIGNATURE.{{"send_source":"personal_information","email":"{recovery_email}","guid":"{Device_ID}","device_id":"{Android_ID}","waterfall_id":"{water}"}}',
        }
        
        response = requests.post(
            'https://i.instagram.com/api/v1/accounts/send_confirm_email/',
            headers=headers,
            data=data,
            proxies=current_proxy,
            timeout=30,
            verify=False
        )
        
        # Check for challenge_required
        challenge_detected_in_response = False
        if 'challenge_required' in response.text.lower():
            challenge_detected_in_response = True
            if 'accounts/suspended' in response.text.lower():
                print(f"[DEBUG] ⚠️ Account suspended/challenge detected when adding recovery email")
            else:
                print(f"[DEBUG] ⚠️ Challenge required detected when adding recovery email")
            return False
        
        if 'ok":true' not in response.text and 'status":"ok"' not in response.text:
            print(f"[DEBUG] ❌ Failed to send confirmation email. Response: {response.text[:200]}")
            return False
        
        print(f"[DEBUG] ✅ Confirmation email sent successfully")
        
        # Step 2: Get verification code or confirmation token from email (with timeout)
        print(f"[DEBUG] Step 2: Waiting for verification code from email (max 60s)...")
        try:
            email_code_or_token = get_verification_code(recovery_email, EMAIL_PASSWORD, max_wait=60)
        except Exception as e:
            print(f"[DEBUG] ❌ Error getting verification code: {e}")
            return False
        
        if not email_code_or_token:
            print(f"[DEBUG] ❌ Failed to get verification code from email (timeout or error)")
            return False
        
        print(f"[DEBUG] ✅ Got verification code/token: {email_code_or_token[:10]}...")
        
        # Step 3: Confirm email recovery using Instagram's account edit endpoint
        print(f"[DEBUG] Step 3: Confirming email recovery...")
        
        # Check if it's a 6-digit code or confirmation token
        if email_code_or_token.isdigit() and len(email_code_or_token) == 6:
            # It's a verification code
            data = {
                'signed_body': f'SIGNATURE.{{"email":"{recovery_email}","verification_code":"{email_code_or_token}","guid":"{Device_ID}","device_id":"{Android_ID}","waterfall_id":"{water}"}}',
            }
        else:
            # It's a confirmation token
            data = {
                'signed_body': f'SIGNATURE.{{"email":"{recovery_email}","confirmation_token":"{email_code_or_token}","guid":"{Device_ID}","device_id":"{Android_ID}","waterfall_id":"{water}"}}',
            }
        
        response = requests.post(
            'https://i.instagram.com/api/v1/accounts/edit_profile/',
            headers=headers,
            data=data,
            proxies=current_proxy,
            timeout=30,
            verify=False
        )
        
        if 'ok":true' in response.text or 'status":"ok"' in response.text:
            print(f"[DEBUG] ✅ Email recovery added successfully: {recovery_email}")
            return True
        else:
            print(f"[DEBUG] ❌ Failed to confirm email recovery. Response: {response.text[:200]}")
            return False
        
    except Exception as e:
        print(f"[DEBUG] ❌ Error adding email recovery: {e}")
        return False

# SMS-Activate Functions
def get_balance():
    """Get SMS-Activate balance with SSL fixes and retry logic"""
    max_retries = 3
    for attempt in range(max_retries):
        try:
            # Use requests with SSL verification disabled
            current_ip = get_current_ip()
            response = requests.get(f"{SMS_API_URL}", params={
                'api_key': SMS_API_KEY,
                'action': 'getBalance'
            }, proxies=current_proxy, timeout=30, verify=False)
            if response.status_code == 200:
                data = response.text
                if data.startswith('ACCESS_BALANCE:'):
                    balance = data.split(':')[1]
                    print(f"💰 SMS-Activate Balance: ${balance}")
                    return float(balance)
                else:
                    print(f"❌ Balance check failed: {data}")
                    if attempt < max_retries - 1:
                        time.sleep(2)
                        continue
                    return 0
            else:
                print(f"❌ Balance check failed: HTTP {response.status_code}")
                if attempt < max_retries - 1:
                    time.sleep(2)
                    continue
                return 0
        except Exception as e:
            print(f"❌ Error checking balance: {e}")
            if attempt < max_retries - 1:
                time.sleep(2)
                continue
            return 0

def get_number():
    """Get phone number from SMS-Activate with SSL fixes and retry logic"""
    global country_global
    max_retries = 3
    for attempt in range(max_retries):
        try:
            # Get phone number from SMS-Activate
            response = requests.get(f"{SMS_API_URL}", params={
                'api_key': SMS_API_KEY,
                'action': 'getNumber',
                'service': 'ig',  # Instagram service
                'country': country_global   # Use country from global variable
            }, proxies=current_proxy, timeout=15, verify=False)
            
            if response.status_code == 200:
                data = response.text
                print(f"🔍 SMS-Activate response: {data}")
                if data.startswith('ACCESS_NUMBER:'):
                    parts = data.split(':')
                    activation_id = parts[1]
                    phone_number = parts[2]
                    return activation_id, phone_number
                elif data.startswith('NO_NUMBERS'):
                    print(f"❌ No numbers available for Instagram in country 16")
                    return None, None
                elif data.startswith('NO_BALANCE'):
                    print(f"❌ Insufficient balance for number purchase")
                    return None, None
                else:
                    print(f"❌ Failed to get number: {data}")
                    if attempt < max_retries - 1:
                        time.sleep(2)
                        continue
                    return None, None
            else:
                print(f"❌ Failed to get number: HTTP {response.status_code}")
                if attempt < max_retries - 1:
                    print(f"🔄 Retrying number request... (attempt {attempt + 2}/{max_retries})")
                    time.sleep(2)
                    continue
                return None, None
        except Exception as e:
            print(f"❌ Error getting number: {e}")
            if attempt < max_retries - 1:
                print(f"🔄 Retrying number request... (attempt {attempt + 2}/{max_retries})")
                time.sleep(2)
                continue
            return None, None

async def get_sms_code(activation_id, max_timeout_seconds=120):
    """Get SMS code from SMS-Activate with max 2 minute timeout (async, cancellable)"""
    import time as time_module
    start_time = time_module.time()
    attempt = 0
    max_attempts = 50  # High number, but we'll exit based on timeout
    
    while (time_module.time() - start_time) < max_timeout_seconds:
        try:
            # Check for cancellation first (allows immediate Ctrl+C)
            await asyncio.sleep(0)  # Yield to event loop to check for cancellation
            
            # Check remaining time
            elapsed = time_module.time() - start_time
            remaining = max_timeout_seconds - elapsed
            
            if remaining <= 0:
                print(f"[DEBUG] ❌ SMS code timeout ({max_timeout_seconds}s)")
                return None
            
            current_ip = get_current_ip()
            # Only log every 30 seconds to reduce noise
            if attempt == 0 or elapsed % 30 < 5:
                print(f"[DEBUG] Waiting for SMS code... ({int(elapsed)}s elapsed)")
            
            response = requests.get(f"{SMS_API_URL}", params={
                'api_key': SMS_API_KEY,
                'action': 'getStatus',
                'id': activation_id
            }, proxies=current_proxy, timeout=30, verify=False)
            
            if response.status_code == 200:
                data = response.text
                if data.startswith('STATUS_WAIT_CODE'):
                    attempt += 1
                    # Use shorter waits with frequent cancellation checks
                    base_wait = min(10 + attempt * 2, 20)  # 10-20 seconds base
                    # Adjust based on remaining time
                    if remaining < 30:
                        wait_secs = min(base_wait / 2, remaining - 2)  # Faster when time is running out
                    else:
                        wait_secs = base_wait + random.uniform(0, 5)
                    
                    wait_secs = max(2, min(wait_secs, remaining - 2))  # At least 2s, but don't exceed timeout
                    
                    # Break wait into smaller chunks to allow immediate cancellation
                    wait_chunks = max(1, int(wait_secs / 2))  # Check every 2 seconds
                    for _ in range(wait_chunks):
                        await asyncio.sleep(2)  # Check for cancellation every 2 seconds
                    continue
                elif data.startswith('STATUS_OK:'):
                    code = data.split(':')[1]
                    elapsed = time_module.time() - start_time
                    print(f"[DEBUG] ✅ SMS code received: {code} (took {int(elapsed)}s)")
                    return code
                elif data.startswith('STATUS_CANCEL'):
                    print(f"[DEBUG] ❌ SMS activation cancelled")
                    return None
                else:
                    print(f"[DEBUG] ❌ SMS status error: {data}")
                    return None
            else:
                print(f"❌ Failed to get SMS status: HTTP {response.status_code}")
                # Brief wait before retrying - check for cancellation
                await asyncio.sleep(2)  # Shorter wait, allows faster cancellation
                continue
        except asyncio.CancelledError:
            print(f"\n[DEBUG] ❌ SMS code waiting cancelled by user (Ctrl+C)")
            # Cancel the activation
            try:
                cancel_activation(activation_id)
            except:
                pass
            raise  # Re-raise to allow proper cancellation
        except KeyboardInterrupt:
            print(f"\n[DEBUG] ❌ SMS code waiting interrupted by user (Ctrl+C)")
            # Cancel the activation
            try:
                cancel_activation(activation_id)
            except:
                pass
            raise asyncio.CancelledError("User cancelled")
        except Exception as e:
            print(f"❌ Error getting SMS code: {e}")
            # Brief jitter before retrying error cases
            elapsed = time_module.time() - start_time
            remaining = max_timeout_seconds - elapsed
            if remaining > 5:
                # Use shorter sleep with cancellation checks
                await asyncio.sleep(2)  # Shorter wait
            else:
                print(f"❌ Timeout: Not enough time remaining ({int(remaining)}s)")
                return None
            continue
    
    elapsed = time_module.time() - start_time
    print(f"[DEBUG] ❌ SMS code timeout ({max_timeout_seconds}s)")
    return None

def request_new_sms_code(activation_id):
    """Request a new SMS code for the same activation_id (status 3 = get another SMS)"""
    try:
        current_ip = get_current_ip()
        print(f"[DEBUG] Requesting new SMS code...")
        response = requests.get(f"{SMS_API_URL}", params={
            'api_key': SMS_API_KEY,
            'action': 'setStatus',
            'id': activation_id,
            'status': '3'  # Request another SMS
        }, proxies=current_proxy, timeout=30, verify=False)
        
        if response.status_code == 200:
            data = response.text.strip()
            
            # Check for BAD_STATUS first (before other checks)
            if 'BAD_STATUS' in data.upper() or 'WRONG_ACTIVATION_ID' in data.upper() or 'WRONG_STATUS' in data.upper():
                print(f"[DEBUG] ❌ Activation expired (BAD_STATUS)")
                return "BAD_STATUS"  # Return special value to indicate bad status
            elif 'ACCESS_ACTIVATION' in data or data == 'ACCESS_RETRY_GET':
                print(f"[DEBUG] ✅ New SMS code requested")
                return True
            else:
                print(f"[DEBUG] ⚠️ Unexpected response: {data}")
                return False
        else:
            print(f"❌ Failed to request new SMS: HTTP {response.status_code}")
            return False
    except Exception as e:
        print(f"❌ Error requesting new SMS code: {e}")
        return False

def cancel_activation(activation_id):
    """Cancel SMS activation with SSL fixes"""
    try:
        response = requests.get(f"{SMS_API_URL}", params={
            'api_key': SMS_API_KEY,
            'action': 'setStatus',
            'id': activation_id,
            'status': '8'  # Cancel
        }, proxies=current_proxy, timeout=30, verify=False)
        print(f"🔄 Cancelled activation {activation_id}")
    except Exception as e:
        print(f"❌ Error cancelling activation: {e}")

async def get_phone_lock(phone_number):
    """Get or create a lock for a phone number to ensure sequential processing"""
    global phone_locks
    
    async with phones_lock:
        if phone_number not in phone_locks:
            phone_locks[phone_number] = asyncio.Lock()
        return phone_locks[phone_number]

async def get_phone_for_task(task_id, accounts_per_phone=5):
    """Get or assign a phone number for a specific task (1 phone per task for N accounts)"""
    global phone_pool, phones_per_task
    
    async with phone_pool_lock:
        # Check if task already has a phone assigned
        if task_id in phones_per_task:
            phone_info = phones_per_task[task_id]
            if phone_info['accounts_count'] < accounts_per_phone:
                # Still can use this phone - increment counter
                phone_info['accounts_count'] += 1
                print(f"[DEBUG] 📱 Phone {phone_info['phone_number']} will be used for account #{phone_info['accounts_count']} of {accounts_per_phone}")
                # Get or create lock for this phone
                phone_lock = await get_phone_lock(phone_info['phone_number'])
                phone_info['lock'] = phone_lock
                return phone_info['activation_id'], phone_info['phone_number'], phone_info
            else:
                # Phone has been used for N accounts (default 5), return to pool for reuse
                print(f"[DEBUG] ♻️ Phone {phone_info['phone_number']} completed {accounts_per_phone} accounts, returning to pool for future reuse")
                # Reset the counter and return to pool so it can be reused for another 5 accounts
                phone_pool.append({
                    'activation_id': phone_info['activation_id'],
                    'phone_number': phone_info['phone_number'],
                    'accounts_used': accounts_per_phone  # Track how many accounts this phone was used for
                })
                # Remove from task assignment - will get new phone or reuse from pool
                del phones_per_task[task_id]
        
        # ALWAYS check pool first before getting new phone - reuse phones from pool
        if phone_pool:
            # Reuse phone from pool (phone that was used for previous 5 accounts)
            phone_info = phone_pool.pop(0)
            print(f"[DEBUG] ♻️ Reusing phone from pool: {phone_info['phone_number']} (was used for {phone_info.get('accounts_used', 0)} accounts)")
            phones_per_task[task_id] = {
                'activation_id': phone_info['activation_id'],
                'phone_number': phone_info['phone_number'],
                'accounts_count': 1  # Start counting from 1 for this new batch
            }
            # Get or create lock for this phone
            phone_lock = await get_phone_lock(phone_info['phone_number'])
            phones_per_task[task_id]['lock'] = phone_lock
            return phone_info['activation_id'], phone_info['phone_number'], phones_per_task[task_id]
        else:
            # Get new phone from SMS-Activate
            activation_id, phone_number = get_number()
            if activation_id and phone_number:
                phones_per_task[task_id] = {
                    'activation_id': activation_id,
                    'phone_number': phone_number,
                    'accounts_count': 1
                }
                # Get or create lock for this phone
                phone_lock = await get_phone_lock(phone_number)
                phones_per_task[task_id]['lock'] = phone_lock
                return activation_id, phone_number, phones_per_task[task_id]
            else:
                print(f"❌ Task {task_id} failed to get phone number")
                return None, None, None

async def return_phone_to_pool(task_id, phone_info):
    """Return a phone to the pool after it's been used (optional cleanup)"""
    global phone_pool
    
    async with phone_pool_lock:
        if phone_info:
            phone_pool.append({
                'activation_id': phone_info['activation_id'],
                'phone_number': phone_info['phone_number'],
                'accounts_used': phone_info.get('accounts_count', 0)
            })
            if task_id in phones_per_task:
                del phones_per_task[task_id]

# Variables
# Latest Instagram API version (2024-2025)
BlockVersion = 'a399f367a2e4aa3e40cdb4aab6535045b23db15f3dea789880aa0970463de062'
App_ID = '567067343352427'  # Instagram Android App ID

def generate_fresh_device_info():
    """Generate fresh device info for each account"""
    global Device_ID, Family_ID, Android_ID, UserAgent, X_Mid, adid, water
    
    Device_ID = generate_uuid()
    Family_ID = generate_uuid()
    Android_ID = generate_android_device_id()
    UserAgent = generate_useragent()
    X_Mid = get_mid()
    adid = str(uuid.uuid4())
    water = str(uuid.uuid4())
    
    print(f"🔄 Generated fresh device info:")
    print(f"   Device ID: {Device_ID[:8]}...")
    print(f"   User Agent: {UserAgent[:50]}...")

# Initialize with first set
Device_ID = generate_uuid()
Family_ID = generate_uuid()
Android_ID = generate_android_device_id()
UserAgent = generate_useragent()
X_Mid = get_mid()
adid = str(uuid.uuid4())

water = str(uuid.uuid4())
# username will be generated fresh for each account

def generate_password():
    """Generate a random password"""
    prefixes = ["Test", "User", "Account", "Profile", "Member"]
    suffixes = ["2024", "2025", "2023", "2022", "2021"]
    symbols = ["@", "#", "$", "!", "&"]
    numbers = str(random.randint(1000, 9999))
    
    prefix = random.choice(prefixes)
    suffix = random.choice(suffixes)
    symbol = random.choice(symbols)
    
    return f"{prefix}{symbol}{suffix}{numbers}"

password = generate_password()
jazoest = generate_jazoest(Family_ID)
birth = Birthday()

bio_spintax = r'{Reposting|Uploading|Posting|Reuploading} {videos|content|shorts} that make you {laugh|lol|😂|😆|😲|😵|🤣}\n You will {thank me|be thankful|be grateful|gr8ful} later {🤜🤛|👍|🤘|🤟|🙏} \n {Giveaways Happening Here|Free Giveaways Here|Product Giveaways Here|Free Products Here|Free Stuff Here|Products Giveaways Happening|Claim your Freebies Now|Claim Free Stuff Now|Get Free Stuff Here|Get Free Products Here|Get Free Gift Cards Here} {🗝|🔑|🔌|📱|💻|⌚️|💰|💵|💎|🎉}\n {⬇️⬇️⬇️|👇👇👇|🔽🔽🔽|⤵️⤵️⤵️}'

def get_web_headers():
    """Get web headers with proper CSRF token"""
    try:
        # First get the main page to get CSRF token
        response = requests.get('https://www.instagram.com/', 
                              headers={'User-Agent': UserAgent}, 
                              proxies=current_proxy, 
                              timeout=30, 
                              verify=False)
        
        # Extract CSRF token from cookies
        csrf_token = response.cookies.get('csrftoken', X_Mid)
        
        # Extract other needed values
        mid = response.cookies.get('mid', Device_ID)
        
        web_headers = {
            'authority': 'www.instagram.com',
            'accept': '*/*',
            'accept-language': 'en-US,en;q=0.9',
            'content-type': 'application/x-www-form-urlencoded',
            'origin': 'https://www.instagram.com',
            'referer': 'https://www.instagram.com/accounts/signup/email/',
            'sec-ch-prefers-color-scheme': 'light',
            'sec-ch-ua': '"Chromium";v="111", "Not(A:Brand";v="8"',
            'sec-ch-ua-mobile': '?1',
            'sec-ch-ua-platform': '"Android"',
            'sec-fetch-dest': 'empty',
            'sec-fetch-mode': 'cors',
            'sec-fetch-site': 'same-origin',
            'user-agent': UserAgent,
            'viewport-width': '360',
            'x-asbd-id': '198387',
            'x-csrftoken': csrf_token,
            'x-ig-app-id': str(App_ID),
            'x-ig-www-claim': '0',
            'x-instagram-ajax': '1',
            'x-requested-with': 'XMLHttpRequest',
            'x-web-device-id': Device_ID,
            'cookie': f'csrftoken={csrf_token}; mid={mid}; ig_did={Device_ID}',
        }
        
        return web_headers
    except Exception as e:
        print(f"Error getting web headers: {e}")
        # Fallback headers
        return {
            'authority': 'www.instagram.com',
            'accept': '*/*',
            'accept-language': 'en-US,en;q=0.9',
            'content-type': 'application/x-www-form-urlencoded',
            'origin': 'https://www.instagram.com',
            'referer': 'https://www.instagram.com/accounts/signup/email/',
            'user-agent': UserAgent,
            'x-csrftoken': X_Mid,
            'x-ig-app-id': str(App_ID),
            'x-web-device-id': Device_ID,
        }

# Mobile API headers (for account creation)
def get_mobile_headers():
    """Generate fresh mobile headers with current device info"""
    return {
        'Host': 'i.instagram.com',
        'X-Ig-App-Locale': 'en_US',
        'X-Ig-Device-Locale': 'en_US',
        'X-Ig-Mapped-Locale': 'en_US',
        'X-Pigeon-Session-Id': generate_uuid('UFS-', '-1'),
        'X-Pigeon-Rawclienttime': str(round(time.time(), 3)),
        'X-Ig-Bandwidth-Speed-Kbps': str(random.randint(2500000, 3000000) / 1000),
        'X-Ig-Bandwidth-Totalbytes-B': str(random.randint(5000000, 90000000)),
        'X-Ig-Bandwidth-Totaltime-Ms': str(random.randint(2000, 9000)),
        'X-Bloks-Version-Id': BlockVersion,
        'X-Ig-Www-Claim': '0',
        'X-Bloks-Is-Layout-Rtl': 'false',
        'X-Ig-Device-Id': Device_ID,
        'X-Ig-Family-Device-Id': Family_ID,
        'X-Ig-Android-Id': Android_ID,
        'X-Ig-Timezone-Offset': '16500',
        'X-Fb-Connection-Type': 'WIFI',
        'X-Ig-Connection-Type': 'WIFI',
        'X-Ig-Capabilities': '3brTv10=',
        'X-Ig-App-Id': App_ID,
        'Priority': 'u=3',
        'User-Agent': UserAgent,
        'Accept-Language': 'en-US',
        'X-Mid': X_Mid,
        'Ig-Intended-User-Id': '0',
        'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
        'X-Fb-Http-Engine': 'Liger',
        'X-Fb-Client-Ip': 'True',
        'X-Fb-Server-Cluster': 'True',
        'Connection': 'close',
    }

mobile_headers = get_mobile_headers()

def fetch_image_bytes(image_url):
    try:
        resp = requests.get(image_url, proxies=current_proxy, timeout=30, verify=False)
        if resp.status_code == 200:
            return resp.content
        return None
    except Exception as e:
        return None

def set_bio(text, session_token=None):
    """Set bio for an account using its own session token (not shared between accounts)"""
    try:
        if not session_token:
            print("⚠️ No session token provided for setting bio")
            return False
        
        headers = get_mobile_headers()
        if session_token:
            headers['Authorization'] = session_token
        
        data = {
            'signed_body': 'SIGNATURE.{"raw_text":"' + text.replace('"', '\\"') + '","_uid":"' + Device_ID + '","device_id":"' + Android_ID + '","guid":"' + Device_ID + '"}',
        }
        r = requests.post(
            'https://i.instagram.com/api/v1/accounts/set_biography/',
            headers=headers,
            data=data,
            proxies=current_proxy,
            timeout=30,
            verify=False
        )
        print(f"🔍 Bio response: {r.text[:200]}")
        
        # Check for challenge_required
        if 'challenge_required' in r.text.lower():
            if 'accounts/suspended' in r.text.lower():
                print(f"⚠️ Account suspended/challenge detected when setting bio")
            else:
                print(f"⚠️ Challenge required detected when setting bio")
            return False
        
        result = 'ok' in r.text or 'status":"ok"' in r.text
        if not result:
            print(f"❌ Bio setting failed - Response: {r.text[:300]}")
        return result
    except Exception as e:
        print(f"❌ Error setting bio: {e}")
        import traceback
        traceback.print_exc()
        return False

def set_profile_picture_from_url(image_url, session_token=None):
    """Set profile picture for an account using its own session token (not shared between accounts)"""
    try:
        if not session_token:
            print("⚠️ No session token provided for setting profile picture")
            return False
        
        if not image_url:
            print("⚠️ No image URL provided")
            return False
        
        # Fetch image using the existing function
        print(f"📥 Fetching image from: {image_url}")
        img_bytes = fetch_image_bytes(image_url)
        if not img_bytes:
            print("❌ Failed to fetch image bytes")
            return False
        
        # Verify image size
        if len(img_bytes) < 1000:  # Too small, likely invalid
            print(f"❌ Image too small: {len(img_bytes)} bytes")
            return False
        
        print(f"✅ Fetched image: {len(img_bytes)} bytes")
        
        # Create BytesIO from bytes and ensure it's at the start
        img = io.BytesIO(img_bytes)
        img.seek(0)
        
        # Prepare upload with file (no signed_body for file uploads - just the file)
        files = {
            'profile_pic': ('profile.jpg', img, 'image/jpeg')
        }
        
        # Get mobile headers with session token (like working version)
        headers = get_mobile_headers()
        if session_token:
            headers['Authorization'] = session_token
        else:
            print("⚠️ No session token provided for setting profile picture")
            return False
        
        # Remove Content-Type - requests will set it automatically for multipart/form-data
        if 'Content-Type' in headers:
            del headers['Content-Type']
        
        # Upload to Instagram via mobile API
        print(f"📤 Uploading profile picture to Instagram...")
        response = requests.post(
            'https://i.instagram.com/api/v1/accounts/change_profile_picture/',
            headers=headers,
            files=files,
            proxies=current_proxy,
            timeout=45,
            verify=False
        )
        
        print(f"🔍 Profile picture response status: {response.status_code}")
        print(f"🔍 Profile picture response: {response.text[:300]}")
        
        # Check for challenge_required
        if 'challenge_required' in response.text.lower():
            if 'accounts/suspended' in response.text.lower():
                print(f"⚠️ Account suspended/challenge detected when setting profile picture")
            else:
                print(f"⚠️ Challenge required detected when setting profile picture")
            return False
        
        # Check response
        if response.status_code == 200:
            try:
                result = response.json()
                if result.get('status') == 'ok':
                    print("✅ Profile picture uploaded successfully")
                    return True
            except:
                # If JSON parsing fails, check text response
                if 'status":"ok"' in response.text or 'ok":true' in response.text:
                    print("✅ Profile picture uploaded successfully")
                    return True
        
        print(f"❌ Profile picture upload failed - Status: {response.status_code}, Response: {response.text[:300]}")
        return False
            
    except Exception as e:
        print(f"❌ Error setting profile picture: {e}")
        import traceback
        traceback.print_exc()
        return False

async def create_single_sms_account(account_num, assigned_proxy=None):
    """Create a single SMS account (async) with automatic proxy rotation and phone reuse"""
    task = asyncio.current_task()
    task_id = id(task) if task else None
    print(f"\n[DEBUG] Starting account #{account_num} (Task: {task_id})")
    
    # Stagger task start to reduce API burst
    await asyncio.sleep(random.uniform(0.5, 2.5))
    
    try:
        # Use automatic proxy rotation with phone pool (1 phone per task for 5 accounts)
        result = await create_account_logic(task_id=task_id, accounts_per_phone=5)
        if result:
            print(f"[DEBUG] ✅ Account #{account_num} created successfully")
            return True, f"SMS Account {account_num}"
        else:
            print(f"[DEBUG] ❌ Account #{account_num} creation failed")
            return False, f"SMS Account {account_num}"
    except Exception as e:
        print(f"[DEBUG] ❌ Error creating account #{account_num}: {e}")
        return False, f"SMS Account {account_num}"

async def create_account_with_assigned_proxy(assigned_proxy):
    """Create account with a specific assigned proxy"""
    global proxies
    
    # Generate fresh device info for this account
    generate_fresh_device_info()
    
    # Use assigned proxy
    if assigned_proxy and use_proxies:
        proxies = get_proxy_from_string(assigned_proxy)
        print(f"🔗 Using assigned proxy: {assigned_proxy}")
        
        # Test proxy connection
        if not test_proxy_connection():
            print("❌ Assigned proxy connection failed, trying without proxy...")
            proxies = None
    else:
        proxies = None
    
    # Rest of the account creation logic (same as create_account)
    return await create_account_logic()

def get_proxy_from_string(proxy_string):
    """Convert proxy string to requests format"""
    if '@' in proxy_string:
        auth_part, host_part = proxy_string.split('@')
        host, port = host_part.split(':')
        if ':' in auth_part:
            username, password = auth_part.split(':', 1)
            proxy_url = f'http://{username}:{password}@{host}:{port}'
        else:
            username = auth_part
            proxy_url = f'http://{username}@{host}:{port}'
        
        return {
            'http': proxy_url,
            'https': proxy_url
        }
    return None

async def create_account_logic(task_id=None, accounts_per_phone=5):
    """Core account creation logic with phone reuse (1 phone per task for 5 accounts)
    Wrapped with timeout to prevent getting stuck"""
    try:
        # Wrap entire account creation in timeout (10 minutes max)
        return await asyncio.wait_for(
            _create_account_logic_internal(task_id, accounts_per_phone),
            timeout=600  # 10 minute max timeout for entire account creation
        )
    except asyncio.TimeoutError:
        print(f"[DEBUG] ❌ Account creation timeout (10 minutes) - aborting")
        return False
    except Exception as e:
        print(f"[DEBUG] ❌ Account creation error: {e}")
        import traceback
        traceback.print_exc()
        return False

async def _create_account_logic_internal(task_id=None, accounts_per_phone=5):
    """Internal account creation logic (called with timeout wrapper)"""
    global current_proxy, country_global
    # Get next proxy in rotation for this account (each account gets its own proxy)
    proxy_num = await get_next_proxy()
    if proxy_num:
        print(f"[DEBUG] Using proxy #{proxy_num}")
    
    # Check SMS-Activate balance (only check once per task)
    if task_id is None or task_id not in phones_per_task:
        try:
            balance = get_balance()
            if balance < 0.1:  # Minimum balance check
                print("[DEBUG] ⚠️ Low balance warning")
        except Exception as e:
            print(f"[DEBUG] ⚠️ Balance check error: {e} - continuing anyway")
    
    # Get phone number from pool or assign new one (1 phone per task for N accounts)
    phone_lock = None
    lock_acquired = False
    if task_id is None:
        # Fallback to old behavior if no task_id
        print("[DEBUG] Getting new phone number...")
        activation_id, phone_number = get_number()
        phone_info = None
        if not activation_id or not phone_number:
            print("[DEBUG] ❌ Failed to get phone number")
            return False
        print(f"[DEBUG] ✅ Got phone: {phone_number} (ID: {activation_id})")
    else:
        # Use phone pool system (reuse phone for same task)
        activation_id, phone_number, phone_info = await get_phone_for_task(task_id, accounts_per_phone)
        if not activation_id or not phone_number:
            print("[DEBUG] ❌ Failed to get phone number")
            return False
        if phone_info and phone_info.get('accounts_count', 0) > 1:
            print(f"[DEBUG] ♻️ Reusing phone {phone_number} for account #{phone_info['accounts_count']} of {accounts_per_phone} in this batch")
            print(f"[DEBUG] 📱 Phone {phone_number} has been used for {phone_info['accounts_count']-1} account(s), creating account #{phone_info['accounts_count']} now")
        else:
            print(f"[DEBUG] ✅ Got NEW phone: {phone_number} (ID: {activation_id}) - Will create up to {accounts_per_phone} accounts with this number")
    
    try:
        # Check phone number
        print(f"[DEBUG] Validating phone number...")
        data = {
            'signed_body': 'SIGNATURE.{"phone_id":"'+Family_ID+'","login_nonce_map":"{}","phone_number":"'+phone_number+'","guid":"'+Device_ID+'","device_id":"' + Android_ID + '","prefill_shown":"False"}',
        }
        try:
            response = requests.post(
                'https://i.instagram.com/api/v1/accounts/check_phone_number/', 
                headers=get_mobile_headers(), 
                data=data,
                proxies=current_proxy,
                timeout=30,
                verify=False
            ).text
        except requests.exceptions.Timeout:
            print(f"[DEBUG] ❌ Phone validation timeout (30s)")
            return False
        except requests.exceptions.RequestException as e:
            print(f"[DEBUG] ❌ Phone validation error: {e}")
            return False
        
        # Use phone lock to ensure sequential processing when multiple accounts use same phone
        phone_lock = phone_info.get('lock') if phone_info else None
        if phone_lock:
            await phone_lock.acquire()
            lock_acquired = True
            
            # Wait 2 minutes between SMS requests for accounts using the same phone
            # This ensures proper spacing between SMS code requests
            if phone_info and phone_info.get('accounts_count', 0) > 1:
                wait_time = 120  # 2 minutes in seconds
                print(f"[DEBUG] ⏳ Waiting {wait_time}s before requesting new SMS code (phone reuse - account #{phone_info['accounts_count']})...")
                await asyncio.sleep(wait_time)
                print(f"[DEBUG] ✅ Wait complete, proceeding to request SMS code for account #{phone_info['accounts_count']}")
        
        # Send SMS code
        print(f"[DEBUG] Requesting SMS code from Instagram...")
        data = {
            'signed_body': 'SIGNATURE.{"phone_id":"' + Family_ID + '","phone_number":"' + phone_number + '","guid":"' + Device_ID + '","device_id":"' + Android_ID + '","android_build_type":"release","waterfall_id":"' + water + '"}',
        }
        try:
            res = requests.post('https://i.instagram.com/api/v1/accounts/send_signup_sms_code/',
                                headers=get_mobile_headers(), 
                                data=data,
                                proxies=current_proxy,
                                timeout=30,
                                verify=False
            ).text
        except requests.exceptions.Timeout:
            print(f"[DEBUG] ❌ SMS request timeout (30s)")
            return False
        except requests.exceptions.RequestException as e:
            print(f"[DEBUG] ❌ SMS request error: {e}")
            return False
        
        # If read timeout or empty response, retry once quickly
        if not res:
            try:
                res = requests.post('https://i.instagram.com/api/v1/accounts/send_signup_sms_code/',
                                    headers=get_mobile_headers(), 
                                    data=data,
                                    proxies=current_proxy,
                                    timeout=45,
                                    verify=False
                ).text
            except Exception:
                pass
        
        # Get SMS code from SMS-Activate (with retry using same phone, max 2 minutes)
        print(f"[DEBUG] Waiting for SMS code (max 120s)... (Press Ctrl+C to cancel immediately)")
        try:
            sms_code = await get_sms_code(activation_id, max_timeout_seconds=120)
        except (asyncio.CancelledError, KeyboardInterrupt):
            print(f"[DEBUG] ❌ Account creation cancelled by user")
            # Release lock if we have it
            if phone_lock and lock_acquired:
                try:
                    phone_lock.release()
                    lock_acquired = False
                except:
                    pass
            return False
        if not sms_code:
            # Try requesting new SMS code for the same activation_id
            new_sms_request_result = request_new_sms_code(activation_id)
            
            # Check if we got BAD_STATUS (activation expired)
            if new_sms_request_result == "BAD_STATUS":
                # Activation expired - cancel it and get a new phone
                print("❌ Activation expired (BAD_STATUS) - getting new phone number...")
                # Release lock if we have it
                if phone_lock and lock_acquired:
                    try:
                        phone_lock.release()
                        lock_acquired = False
                    except Exception as e:
                        pass
                # Cancel the invalid activation
                cancel_activation(activation_id)
                
                # Remove failed phone from task assignment to force getting a new one
                if task_id and task_id in phones_per_task:
                    async with phone_pool_lock:
                        del phones_per_task[task_id]
                
                # Get a FRESH new phone number directly from SMS-Activate (not from pool)
                new_activation_id, new_phone_number = get_number()
                if not new_activation_id or not new_phone_number:
                    return False
                
                # Update with new phone
                activation_id = new_activation_id
                phone_number = new_phone_number
                
                # If using async tasks, assign the new phone to the task
                if task_id:
                    async with phone_pool_lock:
                        phones_per_task[task_id] = {
                            'activation_id': new_activation_id,
                            'phone_number': new_phone_number,
                            'accounts_count': phone_info['accounts_count'] if phone_info else 1
                        }
                        phone_info = phones_per_task[task_id]
                        phone_lock = await get_phone_lock(new_phone_number)
                        phone_info['lock'] = phone_lock
                        await phone_lock.acquire()
                        lock_acquired = True
                else:
                    phone_info = None
                    phone_lock = None
                    lock_acquired = False
                
                # Wait 2 minutes if reusing phone for multiple accounts
                if phone_info and phone_info.get('accounts_count', 0) > 1:
                    await asyncio.sleep(120)
                
                # Resend SMS code with new phone
                data = {
                    'signed_body': 'SIGNATURE.{"phone_id":"' + Family_ID + '","phone_number":"' + phone_number + '","guid":"' + Device_ID + '","device_id":"' + Android_ID + '","android_build_type":"release","waterfall_id":"' + water + '"}',
                }
                try:
                    res = requests.post('https://i.instagram.com/api/v1/accounts/send_signup_sms_code/',
                                    headers=get_mobile_headers(), 
                                    data=data,
                                    proxies=current_proxy,
                                    timeout=30,
                                    verify=False
                    ).text
                except requests.exceptions.Timeout:
                    print(f"[DEBUG] ❌ SMS request timeout (30s) for new phone")
                    return False
                except requests.exceptions.RequestException as e:
                    print(f"[DEBUG] ❌ SMS request error for new phone: {e}")
                    return False
                
                if 'sms_sent":true' not in res:
                    print(f"[DEBUG] ❌ Failed to send SMS to new phone number! Response: {res[:200]}")
                    return False
                
                # Get SMS code for new phone
                try:
                    sms_code = await get_sms_code(activation_id, max_timeout_seconds=120)
                except (asyncio.CancelledError, KeyboardInterrupt):
                    print(f"[DEBUG] ❌ Account creation cancelled by user")
                    if phone_lock and lock_acquired:
                        try:
                            phone_lock.release()
                            lock_acquired = False
                        except:
                            pass
                    return False
                if not sms_code:
                    return False
            elif not new_sms_request_result:
                # Check if the error is WRONG_ACTIVATION_ID (number expired) - only then get new number
                # Check the status to see if activation is invalid
                try:
                    check_response = requests.get(f"{SMS_API_URL}", params={
                        'api_key': SMS_API_KEY,
                        'action': 'getStatus',
                        'id': activation_id
                    }, proxies=current_proxy, timeout=30, verify=False)
                    
                    if check_response.status_code == 200:
                        status_data = check_response.text
                        # If activation is cancelled or wrong ID, get new number
                        if 'STATUS_CANCEL' in status_data or 'WRONG_ACTIVATION_ID' in status_data or 'WRONG_STATUS' in status_data or 'BAD_STATUS' in status_data:
                            # Number expired/invalid - get a new phone number
                            print("❌ Phone number expired/invalid, getting new phone number...")
                            # Release lock if we have it
                            if phone_lock and lock_acquired:
                                try:
                                    phone_lock.release()
                                    lock_acquired = False
                                except Exception as e:
                                    pass
                            # Cancel the invalid activation
                            cancel_activation(activation_id)
                            
                            # Remove failed phone from task assignment to force getting a new one
                            if task_id and task_id in phones_per_task:
                                async with phone_pool_lock:
                                    del phones_per_task[task_id]
                            
                            # Get a FRESH new phone number directly from SMS-Activate (not from pool)
                            new_activation_id, new_phone_number = get_number()
                            if not new_activation_id or not new_phone_number:
                                return False
                            
                            # Update with new phone
                            activation_id = new_activation_id
                            phone_number = new_phone_number
                            
                            # If using async tasks, assign the new phone to the task
                            if task_id:
                                async with phone_pool_lock:
                                    phones_per_task[task_id] = {
                                        'activation_id': new_activation_id,
                                        'phone_number': new_phone_number,
                                        'accounts_count': phone_info['accounts_count'] if phone_info else 1
                                    }
                                    phone_info = phones_per_task[task_id]
                                    phone_lock = await get_phone_lock(new_phone_number)
                                    phone_info['lock'] = phone_lock
                                    await phone_lock.acquire()
                                    lock_acquired = True
                            else:
                                phone_info = None
                                phone_lock = None
                                lock_acquired = False
                            
                            # Wait 2 minutes if reusing phone for multiple accounts
                            if phone_info and phone_info.get('accounts_count', 0) > 1:
                                await asyncio.sleep(120)
                            
                            # Resend SMS code with new phone
                            data = {
                                'signed_body': 'SIGNATURE.{"phone_id":"' + Family_ID + '","phone_number":"' + phone_number + '","guid":"' + Device_ID + '","device_id":"' + Android_ID + '","android_build_type":"release","waterfall_id":"' + water + '"}',
                            }
                            res = requests.post('https://i.instagram.com/api/v1/accounts/send_signup_sms_code/',
                                            headers=get_mobile_headers(), 
                                            data=data,
                                            proxies=current_proxy,
                                            timeout=30,
                                            verify=False
                            ).text
                            
                            # Get SMS code with new phone
                            try:
                                sms_code = await get_sms_code(activation_id, max_timeout_seconds=120)
                            except (asyncio.CancelledError, KeyboardInterrupt):
                                print(f"[DEBUG] ❌ Account creation cancelled by user")
                                if phone_lock and lock_acquired:
                                    try:
                                        phone_lock.release()
                                        lock_acquired = False
                                    except:
                                        pass
                                return False
                            if not sms_code:
                                # Release lock if we have it
                                if phone_lock and lock_acquired:
                                    try:
                                        phone_lock.release()
                                        lock_acquired = False
                                    except Exception as e:
                                        pass
                                # Cancel the new activation too since it failed
                                cancel_activation(activation_id)
                                # Remove from task assignment
                                if task_id and task_id in phones_per_task:
                                    async with phone_pool_lock:
                                        del phones_per_task[task_id]
                                return False
                        else:
                            # Just a temporary failure, not expired - return False to retry later
                            if phone_lock and lock_acquired:
                                try:
                                    phone_lock.release()
                                    lock_acquired = False
                                except Exception as e:
                                    pass
                            return False
                    else:
                        # Can't check status, assume it's still valid - just return False
                        if phone_lock and lock_acquired:
                            try:
                                phone_lock.release()
                                lock_acquired = False
                            except Exception as e:
                                pass
                        return False
                except Exception as e:
                    # Error checking status, assume still valid - just return False
                    if phone_lock and lock_acquired:
                        try:
                            phone_lock.release()
                            lock_acquired = False
                        except Exception as e:
                            pass
                    return False
            else:
                # Successfully requested new SMS, wait and try again with SAME phone
                await asyncio.sleep(5)
                try:
                    sms_code = await get_sms_code(activation_id, max_timeout_seconds=120)
                except (asyncio.CancelledError, KeyboardInterrupt):
                    print(f"[DEBUG] ❌ Account creation cancelled by user")
                    if phone_lock and lock_acquired:
                        try:
                            phone_lock.release()
                            lock_acquired = False
                        except:
                            pass
                    return False
                if not sms_code:
                    # Even after requesting new SMS, still failed - release lock and return False
                    if phone_lock and lock_acquired:
                        try:
                            phone_lock.release()
                            lock_acquired = False
                        except Exception as e:
                            pass
                    return False
        
        # Don't release lock yet - wait until validation is successful
        # This prevents other accounts from using the phone before this account finishes
        
        # Validate SMS code (wait a moment to ensure code is fully received)
        print(f"[DEBUG] Validating SMS code...")
        await asyncio.sleep(2)  # Small delay to ensure code is ready
        data = {
            'signed_body': 'SIGNATURE.{"phone_id":"'+Family_ID+'","phone_number":"'+phone_number+'","verification_code":"'+str(sms_code)+'","guid":"'+Device_ID+'","device_id":"' + Android_ID + '","waterfall_id":"'+water+'"}',
        }
        try:
            validation_response = requests.post('https://i.instagram.com/api/v1/accounts/check_confirmation_code/',
                                headers=get_mobile_headers(), 
                                data=data,
                                proxies=current_proxy,
                                timeout=30,
                                verify=False
            ).text
        except requests.exceptions.Timeout:
            print(f"[DEBUG] ❌ SMS validation timeout (30s)")
            return False
        except requests.exceptions.RequestException as e:
            print(f"[DEBUG] ❌ SMS validation error: {e}")
            return False
        
        # Check if validation failed - might need new code
        validation_failed = '"status":"fail"' in validation_response or '"nonce_valid":false' in validation_response
        if validation_failed:
            # Try requesting a new SMS code and retry
            if request_new_sms_code(activation_id):
                await asyncio.sleep(10)  # Wait for new SMS
                try:
                    new_sms_code = await get_sms_code(activation_id, max_timeout_seconds=120)
                except (asyncio.CancelledError, KeyboardInterrupt):
                    print(f"[DEBUG] ❌ Account creation cancelled by user")
                    if phone_lock and lock_acquired:
                        try:
                            phone_lock.release()
                            lock_acquired = False
                        except:
                            pass
                    return False
                if new_sms_code:
                    sms_code = new_sms_code
                    # Re-validate with new code
                    await asyncio.sleep(2)  # Small delay before re-validation
                    data = {
                        'signed_body': 'SIGNATURE.{"phone_id":"'+Family_ID+'","phone_number":"'+phone_number+'","verification_code":"'+str(sms_code)+'","guid":"'+Device_ID+'","device_id":"' + Android_ID + '","waterfall_id":"'+water+'"}',
                    }
                    validation_response = requests.post('https://i.instagram.com/api/v1/accounts/check_confirmation_code/',
                                        headers=get_mobile_headers(), 
                                        data=data,
                                        proxies=current_proxy,
                                        timeout=30,
                                        verify=False
                    ).text
                    # Check if re-validation also failed
                    if '"status":"fail"' in validation_response or '"nonce_valid":false' in validation_response:
                        pass  # Continue with account creation attempt
        
        # Release phone lock after validation attempt (whether success or fail)
        if phone_lock and lock_acquired:
            try:
                phone_lock.release()
                lock_acquired = False
            except Exception as e:
                pass
        
        # Get username suggestions
        # Use variants if provided, otherwise generate random
        global first_name_list, last_name_list, username_list
        
        # Get first name and last name from variants
        if first_name_list:
            first_name = random.choice(first_name_list)
        else:
            # Fallback to generating random name
            full_name = generate_real_name()
            first_name = full_name.split()[0] if full_name else "User"
        
        if last_name_list:
            last_name = random.choice(last_name_list)
        else:
            # Fallback to generating random name
            full_name = generate_real_name()
            name_parts = full_name.split() if full_name else []
            last_name = name_parts[-1] if len(name_parts) > 1 else "Name"
        
        real_name = f"{first_name} {last_name}"
        
        # Get username from variants (with random number 000000-999999)
        if username_list:
            # Pick ONE variant from the list
            username_variant = random.choice(username_list)
            # Clean and generate username with 6 digits
            username = generate_username_from_variant(username_variant)
            if not username:
                username = generate_random_username()
        else:
            username = generate_random_username()
        
        data = {
            'signed_body': 'SIGNATURE.{"phone_id":"'+Family_ID+'","guid":"'+Device_ID+'","name":"' + real_name + '","device_id":"' + Android_ID + '","email":"","waterfall_id":"'+water+'"}',
        }
        try:
            username_response = requests.post('https://i.instagram.com/api/v1/accounts/username_suggestions/',
                                headers=get_mobile_headers(), 
                                data=data,
                                proxies=current_proxy,
                                timeout=30,
                                verify=False
            ).json()
        except requests.exceptions.Timeout:
            print(f"[DEBUG] ❌ Username suggestions timeout (30s) - using generated username")
            username_response = {}
        except requests.exceptions.RequestException as e:
            print(f"[DEBUG] ❌ Username suggestions error: {e} - using generated username")
            username_response = {}
        
        if 'suggestions_with_metadata' in username_response:
            usname = username_response['suggestions_with_metadata']['suggestions'][0]['username']
        else:
            # Use the generated username directly (already has numbers)
            usname = username
        
        print(f'👤 Username: {usname}')
        
        # Generate fresh password for each account
        password = generate_password()
        print(f'🔑 Password: {password}')
        
        # Create account
        print(f"[DEBUG] Creating Instagram account...")
        if current_proxy:
            proxy_display = current_proxy.get('http', 'N/A')
            # Mask password in proxy URL for display
            if '@' in proxy_display and ':' in proxy_display.split('@')[0]:
                masked_proxy = proxy_display.split('@')[0].split(':')[0] + ':***@' + proxy_display.split('@')[1]
            else:
                masked_proxy = proxy_display
            print(f"[DEBUG] 🌐 Using proxy: {masked_proxy}")
        else:
            print(f"[DEBUG] 🌐 No proxy (direct connection)")
        timpp = int(datetime.now().timestamp())
        # For SMS-based accounts, email field should be empty - recovery email will be added after account creation
        data = {
            'signed_body': 'SIGNATURE.{"is_secondary_account_creation":"false","jazoest":"' + jazoest + '","tos_version":"row","suggestedUsername":"","verification_code":"'+str(sms_code)+'","sn_result":"API_ERROR: class X.2mY:7: ","do_not_auto_login_if_credentials_match":"true","phone_id":"'+Family_ID+'","enc_password":"#PWD_INSTAGRAM:0:'+str(timpp)+':' + password + '","phone_number":"'+str(phone_number)+'","username":"'+str(usname)+'","first_name":"'+real_name+'","day":"' + birth[0] + '","adid":"'+adid+'","guid":"'+Device_ID+'","year":"' + birth[1] + '","device_id":"' + Android_ID + '","_uuid":"'+Device_ID+'","month":"' + birth[2] + '","sn_nonce":"","force_sign_up_code":"","waterfall_id":"'+water+'","qs_stamp":"","has_sms_consent":"true","one_tap_opt_in":"true"}',
        }
        try:
            response = requests.post(
                'https://i.instagram.com/api/v1/accounts/create_validated/', 
                headers=get_mobile_headers(), 
                data=data,
                proxies=current_proxy,
                timeout=60,  # Increased timeout to 60s
                verify=False
            )
        except requests.exceptions.Timeout:
            print(f"[DEBUG] ❌ Account creation request timeout (60s)")
            return False
        except requests.exceptions.RequestException as e:
            print(f"[DEBUG] ❌ Account creation request error: {e}")
            return False
        
        # Check if account creation failed due to invalid nonce - retry with new SMS code
        account_creation_successful = 'account_created":true' in response.text
        
        # Check for challenge_required (especially accounts/suspended)
        challenge_detected = False
        if 'challenge_required' in response.text.lower():
            challenge_detected = True
            if 'accounts/suspended' in response.text.lower():
                print(f"[DEBUG] ⚠️ Account suspended/challenge detected - will not save to Supabase")
            else:
                print(f"[DEBUG] ⚠️ Challenge required detected - will not save to Supabase")
        
        if account_creation_successful:
            print(f"[DEBUG] ✅ Account created: {usname}")
        elif not account_creation_successful:
            # Log the actual error response for debugging
            print(f"[DEBUG] ❌ Account creation failed. Response status: {response.status_code}")
            print(f"[DEBUG] ❌ Response text: {response.text[:500]}")  # First 500 chars of response
            
            # Check for specific error types
            if '"invalid_nonce"' in response.text or '"nonce_valid":false' in response.text or '"InvalidNonceException"' in response.text:
                print(f"[DEBUG] ⚠️ Invalid nonce, requesting new SMS code...")
                # Request new SMS code
                if request_new_sms_code(activation_id):
                    await asyncio.sleep(10)  # Wait for new SMS
                    
                    # Get new SMS code
                    try:
                        new_sms_code = await get_sms_code(activation_id, max_timeout_seconds=120)
                    except (asyncio.CancelledError, KeyboardInterrupt):
                        print(f"[DEBUG] ❌ Account creation cancelled by user")
                        if phone_lock and lock_acquired:
                            try:
                                phone_lock.release()
                                lock_acquired = False
                            except:
                                pass
                        return False
                    if new_sms_code:
                        # Re-validate with new code
                        await asyncio.sleep(2)
                        data = {
                            'signed_body': 'SIGNATURE.{"phone_id":"'+Family_ID+'","phone_number":"'+phone_number+'","verification_code":"'+str(new_sms_code)+'","guid":"'+Device_ID+'","device_id":"' + Android_ID + '","waterfall_id":"'+water+'"}',
                        }
                        validation_response = requests.post('https://i.instagram.com/api/v1/accounts/check_confirmation_code/',
                                            headers=get_mobile_headers(), 
                                            data=data,
                                            proxies=current_proxy,
                                            timeout=30,
                                            verify=False
                        ).text
                        
                        # Try account creation again with new code
                        timpp = int(datetime.now().timestamp())
                        data = {
                            'signed_body': 'SIGNATURE.{"is_secondary_account_creation":"false","jazoest":"' + jazoest + '","tos_version":"row","suggestedUsername":"","verification_code":"'+str(new_sms_code)+'","sn_result":"API_ERROR: class X.2mY:7: ","do_not_auto_login_if_credentials_match":"true","phone_id":"'+Family_ID+'","enc_password":"#PWD_INSTAGRAM:0:'+str(timpp)+':' + password + '","phone_number":"'+str(phone_number)+'","username":"'+str(usname)+'","first_name":"'+real_name+'","day":"' + birth[0] + '","adid":"'+adid+'","guid":"'+Device_ID+'","year":"' + birth[1] + '","device_id":"' + Android_ID + '","_uuid":"'+Device_ID+'","month":"' + birth[2] + '","sn_nonce":"","force_sign_up_code":"","waterfall_id":"'+water+'","qs_stamp":"","has_sms_consent":"true","one_tap_opt_in":"true"}',
                        }
                        response = requests.post(
                            'https://i.instagram.com/api/v1/accounts/create_validated/', 
                            headers=get_mobile_headers(), 
                            data=data,
                            proxies=current_proxy,
                            timeout=45,
                            verify=False
                        )
                        account_creation_successful = 'account_created":true' in response.text
                        
                        # Check for challenge_required in retry response
                        if 'challenge_required' in response.text.lower():
                            challenge_detected = True
                            if 'accounts/suspended' in response.text.lower():
                                print(f"[DEBUG] ⚠️ Account suspended/challenge detected in retry - will not save to Supabase")
                            else:
                                print(f"[DEBUG] ⚠️ Challenge required detected in retry - will not save to Supabase")
                        
                        if account_creation_successful:
                            sms_code = new_sms_code  # Update sms_code for consistency
                            print(f"[DEBUG] ✅ Account created with new SMS code: {usname}")
                        else:
                            print(f"[DEBUG] ❌ Account creation still failed after new SMS code. Response: {response.text[:500]}")
                    else:
                        print(f"[DEBUG] ❌ Failed to get new SMS code for retry")
                else:
                    print(f"[DEBUG] ❌ Failed to request new SMS code")
        
        if account_creation_successful:
            # Extract token from response headers to maintain session (per account, not global)
            session_token = None
            if 'ig-set-authorization' in response.headers:
                session_token = response.headers['ig-set-authorization']
            
            # Extract session ID from response cookies
            account_session_id = None
            if response.cookies:
                account_session_id = response.cookies.get('sessionid', None)
                if account_session_id:
                    print(f"[DEBUG] ✅ Extracted session ID from cookies: {account_session_id[:20]}...")
            
            # Recovery email will be added during setup_account_task
            recovery_email = None
            
            # Get proxy string that was used for account creation
            proxy_string = None
            if current_proxy and isinstance(current_proxy, dict):
                # Extract proxy URL from current_proxy dict
                proxy_url = current_proxy.get('http') or current_proxy.get('https')
                if proxy_url:
                    # Convert proxy URL back to string format if needed
                    proxy_string = proxy_url
            
            # Save to files with new format: username:pass:email:emailpassword
            # Note: recovery_email will be set during setup_account_task
            print(f"[DEBUG] Saving account to files...")
            # Will update with recovery_email after setup completes
            with open('accounts.txt', 'a') as f:
                f.write(f'{usname}:{password}:{phone_number}:{session_token if session_token else ""}\n')
            
            with open('acc.txt', 'a') as f:
                f.write(f'{phone_number}:{password}\n')
            
            # Setup account (add recovery email, bio, and profile picture) using session token
            print(f"[DEBUG] Setting up account (recovery email, bio + profile picture)...")
            login_result = None
            login_status = "ok"
            login_message = None
            suspended_reason = None
            
            # Setup account using session token (no instagrapi login)
            async def setup_account_task():
                try:
                    await asyncio.sleep(3)  # Wait a bit before setup
                    
                    global bio_list, profile_image_url_list
                    selected_bio = None
                    if bio_list:
                        selected_bio = random.choice(bio_list)
                    
                    # Pick random profile image URL from list
                    selected_image_url = None
                    if profile_image_url_list:
                        selected_image_url = random.choice(profile_image_url_list)
                    
                    # Get email from email_scalingtothemoon_com.csv
                    recovery_email = get_available_email()
                    if not recovery_email:
                        print(f"[DEBUG] ⚠️ No available email from CSV for recovery")
                        recovery_email = None
                    else:
                        print(f"[DEBUG] 📧 Got recovery email from CSV: {recovery_email}")
                    
                    # Track if challenge detected during setup
                    setup_challenge_detected = False
                    
                    # Add recovery email if we have one
                    if recovery_email and session_token:
                        print(f"[DEBUG] Adding recovery email: {recovery_email}")
                        email_added = add_email_recovery_to_sms_account(usname, password, phone_number, recovery_email, session_token)
                        if not email_added:
                            print(f"[DEBUG] ⚠️ Failed to add recovery email")
                            # Check if it was due to challenge (add_email_recovery_to_sms_account prints challenge messages)
                            # We'll detect it by checking the response in add_email_recovery_to_sms_account
                        else:
                            # Move email to used after successful addition
                            move_email_to_used(recovery_email)
                            print(f"[DEBUG] ✅ Recovery email added and moved to used emails")
                    else:
                        print(f"[DEBUG] ⚠️ Skipping recovery email (no email or session token)")
                    
                    # Set bio using session token
                    bio_set = False
                    if selected_bio and session_token:
                        print(f"[DEBUG] Setting bio: {selected_bio}")
                        bio_set = set_bio(selected_bio, session_token)
                        if not bio_set:
                            print(f"[DEBUG] ⚠️ Failed to set bio")
                            # Check if challenge was detected (set_bio prints challenge messages)
                            # If challenge detected, set_bio returns False
                        else:
                            print(f"[DEBUG] ✅ Bio set successfully")
                    
                    # Profile picture will be set using instagrapi after login (removed manual upload)
                    
                    # Check if any of the setup steps detected a challenge
                    # We need to check the actual responses, but since the functions return False on challenge,
                    # we'll need to track it differently. For now, we'll check if any step failed with challenge message.
                    # The challenge detection is already printed by the functions, so we'll rely on that.
                    
                    return {
                        "status": "ok",
                        "message": "Account setup completed",
                        "bio_set": bio_set,
                        "bio": selected_bio if selected_bio else None,  # Return the actual bio text (even if setting failed, so we know what was attempted)
                        "pic_set": False,  # Profile picture will be set by instagrapi
                        "recovery_email": recovery_email if recovery_email else None,
                        "challenge_detected": setup_challenge_detected,
                        "profile_image_url": selected_image_url if selected_image_url else None  # Pass URL for instagrapi
                    }
                except Exception as e:
                    print(f"[DEBUG] ⚠️ Setup error for {usname}: {e}")
                    import traceback
                    traceback.print_exc()
                    return {
                        "status": "error",
                        "message": f"Setup error: {str(e)}"
                    }
            
            try:
                # Run setup with timeout
                login_result = await asyncio.wait_for(setup_account_task(), timeout=120)
                
                # Extract login status and messages
                login_status = login_result.get("status", "ok")
                login_message = login_result.get("message")
                suspended_reason = None
                
                # Update recovery_email if it was set during setup
                if login_result.get("recovery_email"):
                    recovery_email = login_result.get("recovery_email")
                    # Update accounts.txt with recovery email
                    try:
                        # Read current accounts.txt
                        with open('accounts.txt', 'r') as f:
                            lines = f.readlines()
                        # Update the last line (this account) with recovery email
                        if lines:
                            last_line = lines[-1].strip()
                            if last_line.startswith(f'{usname}:{password}:'):
                                lines[-1] = f'{usname}:{password}:{recovery_email}:{EMAIL_PASSWORD}\n'
                                with open('accounts.txt', 'w') as f:
                                    f.writelines(lines)
                                print(f"[DEBUG] ✅ Updated accounts.txt with recovery email")
                    except Exception as e:
                        print(f"[DEBUG] ⚠️ Failed to update accounts.txt: {e}")
            except asyncio.TimeoutError:
                print(f"[DEBUG] ⏱️ Setup task timeout for {usname} - continuing anyway")
                login_status = "suspended"
                login_message = "Setup task timeout"
                suspended_reason = "Setup timeout"
            except Exception as e:
                print(f"[DEBUG] ⚠️ Setup task error for {usname}: {e}")
                login_status = "error"
                login_message = f"Setup task error: {str(e)}"
            
            # Check if challenge was detected during setup
            setup_challenge_detected = False
            if login_result and isinstance(login_result, dict):
                setup_challenge_detected = login_result.get("challenge_detected", False)
            
            # Login with instagrapi FIRST - only save to Supabase if login is successful
            print(f"[DEBUG] 🔐 Logging in with instagrapi to save session and set profile picture...")
            try:
                if INSTAGRAPI_AVAILABLE:
                    # Get proxy URL for login (use random proxy)
                    proxy_url = None
                    if current_proxy and isinstance(current_proxy, dict):
                        proxy_url = current_proxy.get('http') or current_proxy.get('https')
                    else:
                        # If no proxy was set, get a random one from proxies.txt
                        if use_proxies:
                            proxy_string = get_random_proxy()
                            if proxy_string:
                                # get_random_proxy already adds http:// scheme, so use it directly
                                proxy_url = proxy_string
                            else:
                                # Try to get from PROXIES list directly (fallback)
                                if PROXIES:
                                    proxy_string = random.choice(PROXIES)
                                    # Replace country keyword if needed
                                    if country_global in COUNTRY_TO_PROXY_KEYWORD:
                                        proxy_keyword = COUNTRY_TO_PROXY_KEYWORD[country_global]
                                        import re
                                        proxy_string = re.sub(r';(us|uk|br|id|ca);', f';{proxy_keyword};', proxy_string)
                                    
                                    # Parse proxy format and add scheme
                                    if '@' in proxy_string:
                                        auth_part, host_part = proxy_string.split('@')
                                        host, port = host_part.split(':')
                                        if ':' in auth_part:
                                            username, password = auth_part.split(':', 1)
                                            proxy_url = f'http://{username}:{password}@{host}:{port}'
                                        else:
                                            proxy_url = f'http://{auth_part}@{host}:{port}'
                                    else:
                                        proxy_url = None
                                else:
                                    proxy_url = None
                    
                    # Login with instagrapi and save session
                    cl = Client()
                    
                    # Set proxy if available
                    if proxy_url:
                        try:
                            # Ensure proxy has proper scheme
                            if not proxy_url.startswith(('http://', 'https://', 'socks4://', 'socks5://')):
                                proxy_url = f"http://{proxy_url}"
                            cl.set_proxy(proxy_url)
                            print(f"[DEBUG] 🔗 Using proxy for instagrapi login: {proxy_url[:50]}...")
                        except Exception as e:
                            print(f"[DEBUG] ⚠️ Failed to set proxy for instagrapi: {e}")
                    
                    # Set up challenge handler for email verification codes using default IMAP
                    # Get recovery email from login_result or use phone_number as fallback
                    email_for_challenge = None
                    if login_result and login_result.get("recovery_email"):
                        email_for_challenge = login_result.get("recovery_email")
                    elif recovery_email:
                        email_for_challenge = recovery_email
                    
                    if email_for_challenge:
                        # Track challenge attempts
                        challenge_attempts = {"count": 0}
                        max_challenge_attempts = 2
                        
                        def challenge_code_handler(insta_username, choice):
                            """Handle Instagram challenge codes via IMAP using default IMAP settings"""
                            if challenge_attempts["count"] >= max_challenge_attempts:
                                return False
                            
                            challenge_attempts["count"] += 1
                            
                            if choice == ChallengeChoice.EMAIL:
                                print(f"[DEBUG] Challenge via EMAIL (attempt {challenge_attempts['count']}/{max_challenge_attempts})")
                                print(f"[DEBUG] 📧 Instagram will send a NEW verification code to {email_for_challenge} for login challenge...")
                                print(f"[DEBUG] ⏳ Waiting for NEW challenge email...")
                                
                                # Record when challenge started
                                import time
                                challenge_start_time = time.time()
                                time.sleep(10)  # Wait 10 seconds for email to arrive
                                
                                # Get verification code using default IMAP settings
                                code = get_verification_code_for_challenge(
                                    email_for_challenge, 
                                    EMAIL_PASSWORD,  # Use default IMAP password
                                    max_wait=60, 
                                    min_timestamp=challenge_start_time
                                )
                                if code:
                                    print(f"[DEBUG] ✅ Challenge code retrieved: {code}")
                                    return code
                                else:
                                    print(f"[DEBUG] ❌ Failed to retrieve challenge code (attempt {challenge_attempts['count']}/{max_challenge_attempts})")
                                    return False
                            elif choice == ChallengeChoice.SMS:
                                print(f"[DEBUG] 📱 Challenge via SMS for {insta_username} - SMS not supported")
                                return False
                            return False
                        
                        cl.challenge_code_handler = challenge_code_handler
                        print(f"[DEBUG] ✅ Challenge code handler set for {usname} using email {email_for_challenge} with default IMAP")
                    else:
                        print(f"[DEBUG] ⚠️ No recovery email available for challenge handler")
                    
                    # Login (run in executor to avoid blocking)
                    loop = asyncio.get_event_loop()
                    await asyncio.wait_for(
                        loop.run_in_executor(None, lambda: cl.login(usname, password)),
                        timeout=90
                    )
                    print(f"[DEBUG] ✅ Instagrapi login successful")
                    
                    # Set profile picture using instagrapi if URL is available
                    if login_result and login_result.get("profile_image_url"):
                        profile_image_url = login_result.get("profile_image_url")
                        try:
                            print(f"[DEBUG] 📸 Setting profile picture using instagrapi from: {profile_image_url}")
                            # Download image
                            import tempfile
                            import httpx
                            async with httpx.AsyncClient(timeout=30.0) as http_client:
                                img_response = await http_client.get(profile_image_url)
                                img_response.raise_for_status()
                                
                                # Save to temp file
                                with tempfile.NamedTemporaryFile(delete=False, suffix='.jpg') as tmp_file:
                                    tmp_file.write(img_response.content)
                                    tmp_path = tmp_file.name
                            
                            # Upload profile picture using instagrapi
                            from pathlib import Path
                            await asyncio.wait_for(
                                loop.run_in_executor(None, lambda: cl.account_change_picture(Path(tmp_path))),
                                timeout=45
                            )
                            print(f"[DEBUG] ✅ Profile picture set successfully using instagrapi")
                            
                            # Clean up temp file
                            try:
                                os.unlink(tmp_path)
                            except:
                                pass
                        except Exception as pic_error:
                            print(f"[DEBUG] ⚠️ Failed to set profile picture with instagrapi: {pic_error}")
                            # Continue anyway - profile picture is not critical
                    
                    # Save session to username_session.json format
                    session_path = session_file_for(usname)
                    await asyncio.wait_for(
                        loop.run_in_executor(None, lambda: cl.dump_settings(session_path)),
                        timeout=10
                    )
                    print(f"[DEBUG] ✅ Session saved to: {session_path}")
                    
                    # Only save to Supabase if instagrapi login was successful
                    if not (challenge_detected or setup_challenge_detected):
                        print(f"[DEBUG] Saving to Supabase (instagrapi login successful, no challenge detected)...")
                        try:
                            # Get proxy URL from current_proxy (not the proxy string format)
                            proxy_url_for_supabase = None
                            if current_proxy and isinstance(current_proxy, dict):
                                proxy_url_for_supabase = current_proxy.get('http') or current_proxy.get('https')
                            elif proxy_url:
                                proxy_url_for_supabase = proxy_url
                            
                            # Get country name from country code
                            creation_country_name = None
                            if country_global and country_global in COUNTRY_CODE_TO_NAME:
                                creation_country_name = COUNTRY_CODE_TO_NAME[country_global]
                            
                            # Get account info from instagrapi client for Supabase
                            try:
                                account_info = await asyncio.wait_for(
                                    loop.run_in_executor(None, lambda: cl.account_info()),
                                    timeout=20
                                )
                                followers = account_info.follower_count if hasattr(account_info, 'follower_count') else None
                                following = account_info.following_count if hasattr(account_info, 'following_count') else None
                                ig_name = account_info.full_name if hasattr(account_info, 'full_name') else None
                                bio = account_info.biography if hasattr(account_info, 'biography') else None
                                instagram_id = str(account_info.pk) if hasattr(account_info, 'pk') else None
                            except Exception as info_error:
                                print(f"[DEBUG] ⚠️ Could not fetch account info for Supabase: {info_error}")
                                followers = None
                                following = None
                                ig_name = None
                                bio = None
                                instagram_id = None
                            
                            await save_account_to_supabase(
                                username=usname,
                                password=password,
                                email=recovery_email if recovery_email else phone_number,
                                email_password=EMAIL_PASSWORD if recovery_email else "",
                                proxy=proxy_url_for_supabase,  # Save proxy URL, not proxy string format
                                session_data=None,  # Session is saved to file, not needed in Supabase
                                user_agent="",  # Not needed
                                followers=followers,
                                following=following,
                                ig_name=ig_name,
                                bio=bio,
                                instagram_id=instagram_id,
                                tag=tag_global,
                                login_status="ok",  # Login successful
                                login_message="Instagrapi login successful",
                                suspended_reason=None,
                                mobile=phone_number,  # Phone number used for account generation
                                creation_proxy=proxy_url_for_supabase,  # Proxy URL used for account creation
                                creation_country=creation_country_name,  # Country name (e.g., "USA", "United Kingdom", "Brazil", "Indonesia", "Canada")
                                session_id=account_session_id  # Session ID extracted from account creation response cookies
                            )
                            print(f"[DEBUG] ✅ Saved to Supabase (instagrapi login successful)")
                        except Exception as e:
                            print(f"[DEBUG] ❌ Failed to save to Supabase: {e}")
                    else:
                        print(f"[DEBUG] ⚠️ Challenge detected - skipping Supabase save (account suspended or challenge required)")
                        # Save to txt file only
                        try:
                            with open('accounts.txt', 'a') as f:
                                f.write(f'{usname}:{password}:{recovery_email if recovery_email else phone_number}:{EMAIL_PASSWORD if recovery_email else ""}\n')
                            print(f"[DEBUG] ✅ Saved to accounts.txt (challenge detected, not saved to Supabase)")
                        except Exception as e:
                            print(f"[DEBUG] ⚠️ Failed to save to accounts.txt: {e}")
                else:
                    print(f"[DEBUG] ⚠️ Instagrapi not available, skipping session save and Supabase")
                    # Save to txt file only if instagrapi not available
                    try:
                        with open('accounts.txt', 'a') as f:
                            f.write(f'{usname}:{password}:{recovery_email if recovery_email else phone_number}:{EMAIL_PASSWORD if recovery_email else ""}\n')
                        print(f"[DEBUG] ✅ Saved to accounts.txt (instagrapi not available)")
                    except Exception as e:
                        print(f"[DEBUG] ⚠️ Failed to save to accounts.txt: {e}")
            except asyncio.TimeoutError:
                print(f"[DEBUG] ⚠️ Instagrapi login/save timeout - saving to txt only (not Supabase)")
                # Save to txt file only
                try:
                    with open('accounts.txt', 'a') as f:
                        f.write(f'{usname}:{password}:{recovery_email if recovery_email else phone_number}:{EMAIL_PASSWORD if recovery_email else ""}\n')
                    print(f"[DEBUG] ✅ Saved to accounts.txt (login timeout)")
                except Exception as e:
                    print(f"[DEBUG] ⚠️ Failed to save to accounts.txt: {e}")
            except Exception as e:
                print(f"[DEBUG] ⚠️ Failed to login/save session with instagrapi: {e}")
                print(f"[DEBUG] ⚠️ Saving to txt only (login failed, not saved to Supabase)")
                # Save to txt file only
                try:
                    with open('accounts.txt', 'a') as f:
                        f.write(f'{usname}:{password}:{recovery_email if recovery_email else phone_number}:{EMAIL_PASSWORD if recovery_email else ""}\n')
                    print(f"[DEBUG] ✅ Saved to accounts.txt (login failed)")
                except Exception as save_error:
                    print(f"[DEBUG] ⚠️ Failed to save to accounts.txt: {save_error}")
            
            print(f"[DEBUG] ✅ Account creation complete: {usname}")
            if phone_info and task_id:
                print(f"[DEBUG] 📊 Phone {phone_number} usage: {phone_info.get('accounts_count', 0)}/{accounts_per_phone} accounts created with this number")
            return True
        else:
            print(f"[DEBUG] ❌ Account creation failed - saving to txt only (not Supabase)")
            # Save failed account to txt file for reference
            try:
                with open('accounts.txt', 'a') as f:
                    f.write(f'{usname if "usname" in locals() else "FAILED"}:{password if "password" in locals() else "FAILED"}:{phone_number}:FAILED\n')
                print(f"[DEBUG] Saved failed account to txt file")
            except Exception as e:
                print(f"[DEBUG] Failed to save failed account to txt: {e}")
            
            # Release lock if we have it and it was acquired (even on failure)
            if phone_lock and lock_acquired:
                try:
                    phone_lock.release()
                    lock_acquired = False
                except Exception as e:
                    pass
            return False
            
    except Exception as e:
        print(f"[DEBUG] Account creation error: {e} - saving to txt only (not Supabase)")
        # Save failed account to txt file for reference
        try:
            with open('accounts.txt', 'a') as f:
                f.write(f'ERROR:{str(e)[:50]}:{phone_number if "phone_number" in locals() else "UNKNOWN"}:FAILED\n')
            print(f"[DEBUG] Saved error account to txt file")
        except Exception as save_error:
            print(f"[DEBUG] Failed to save error account to txt: {save_error}")
        
        # Release lock if we have it and it was acquired (even on error)
        if phone_lock and lock_acquired:
            try:
                phone_lock.release()
                lock_acquired = False
            except Exception:
                pass
        return False

def follow_user(username, session_token=None):
    """Follow a user using Instagram API"""
    try:
        headers = get_mobile_headers()
        if session_token:
            headers['Authorization'] = session_token
        else:
            return False
        
        # First get user ID from username
        user_id_response = requests.get(
            f'https://i.instagram.com/api/v1/users/{username}/usernameinfo/',
            headers=headers,
            proxies=current_proxy,
            timeout=30,
            verify=False
        )
        
        if user_id_response.status_code != 200:
            return False
        
        try:
            user_data = user_id_response.json()
            user_id = user_data.get('user', {}).get('pk')
            if not user_id:
                return False
        except:
            return False
        
        # Follow the user using the correct endpoint
        data = {
            'signed_body': f'SIGNATURE.{{"user_id":"{user_id}","device_id":"{Android_ID}","guid":"{Device_ID}","_uuid":"{Device_ID}"}}',
        }
        
        response = requests.post(
            f'https://i.instagram.com/api/v1/friendships/create/{user_id}/',
            headers=headers,
            data=data,
            proxies=current_proxy,
            timeout=30,
            verify=False
        )
        
        if response.status_code == 200:
            return 'status":"ok"' in response.text or 'ok":true' in response.text or '"friendship_status"' in response.text
        
        return False
    except Exception as e:
        return False

def follow_users(session_token=None):
    """Follow the specified users after account creation"""
    users_to_follow = ['david_8194', 'david_89194', 'wirelessiron59']
    
    if not session_token:
        return
    
    for username in users_to_follow:
        try:
            follow_user(username, session_token)
            time.sleep(random.randint(2, 5))  # Wait between follows
        except:
            pass

def get_random_bio():
    # Try simple random placeholder or use online service if available
    candidates = [
        'Traveler. Dreamer. Lifelong learner.',
        'Coffee enthusiast ☕ | Music lover 🎶',
        'Trying to make every day count 🌍',
        'Adventure seeker. Cat person.',
        'Digital creator. Spreading positivity! ✨',
        'Living my best life!',
        'Believe in yourself and magic will happen.',
        'Work hard. Stay humble. Smile often.'
    ]
    try:
        resp = requests.get('https://api.quotable.io/random?maxLength=40', timeout=10)
        if resp.status_code == 200:
            quote = resp.json().get('content')
            if quote:
                return quote
    except:
        pass
    return random.choice(candidates)

# Profile picture URLs should come from API request only - no hardcoded generation

# Helper functions for login and saving
# Use sessions folder in parent directory (same as media.py and login.py)
SESSIONS_DIR = os.path.join(os.path.dirname(os.path.dirname(__file__)), "sessions")
os.makedirs(SESSIONS_DIR, exist_ok=True)

def session_file_for(username: str) -> str:
    """Get session file path for username in format: username_session.json"""
    # Use username as-is (not lowercased) to match other modules
    return os.path.join(SESSIONS_DIR, f"{username}_session.json")

def generate_random_id(length=15) -> str:
    """Generate random ID like '01fmcQ5wGAyjbDqB'"""
    chars = string.ascii_letters + string.digits
    return ''.join(random.choices(chars, k=length))

def generate_workflow_id(length=15) -> str:
    """Generate random workflow ID like 'kGaq1E86JkRca3Rg'"""
    chars = string.ascii_letters + string.digits
    return ''.join(random.choices(chars, k=length))

def generate_account_string(username: str, password: str, session_data: Dict, user_agent: str, cookies: str, proxy: Optional[str] = None, email: Optional[str] = None, email_password: Optional[str] = None) -> str:
    """Generate account_string format: username:password|Instagram version|User-Agent|cookies|proxy|email:email_password"""
    instagram_version = session_data.get("device_settings", {}).get("app_version", "350.0.0.28.96")
    android_version = session_data.get("device_settings", {}).get("android_version", "26")
    android_release = session_data.get("device_settings", {}).get("android_release", "8.0")
    instagram_info = f"Instagram {instagram_version} Android ({android_version}/{android_release}; 560dpi; 1440x2560; samsung; SM-G930F; herolte; samsungexynos8890; en_US; 750732795)"
    
    uuids = session_data.get("uuids", {})
    android_device_id = uuids.get("android_device_id", "android-f1b15afc37b59351")
    phone_id = uuids.get("phone_id", "")
    uuid_val = uuids.get("uuid", "")
    advertising_id = uuids.get("advertising_id", "")
    
    uuid_parts = [android_device_id]
    if phone_id:
        uuid_parts.append(phone_id)
    if uuid_val:
        uuid_parts.append(uuid_val)
    if advertising_id:
        uuid_parts.append(advertising_id)
    uuid_str = ";".join(uuid_parts) if uuid_parts else ""
    
    auth_data = session_data.get("authorization_data", {})
    ds_user_id = auth_data.get("ds_user_id", "")
    sessionid = auth_data.get("sessionid", "")
    mid = session_data.get("mid", "")
    
    cookies_parts = []
    if ds_user_id:
        cookies_parts.append(f"rur=HIL,{ds_user_id},1788275080:01fea7288b0a6508624390878b012f092c7cd6837a96601ced332144ad267b12830faa9e")
    if mid:
        cookies_parts.append(f"mid={mid}")
    if ds_user_id:
        cookies_parts.append(f"ds_user_id={ds_user_id}")
    if sessionid:
        cookies_parts.append(f"sessionid={sessionid}")
    cookies_str = ";".join(cookies_parts) if cookies_parts else ""
    
    proxy_str = proxy if proxy else ""
    email_str = f"{email}:{email_password}" if email and email_password else ""
    
    parts = [
        f"{username}:{password}",
        instagram_info,
        user_agent,
        uuid_str,
        cookies_str,
        proxy_str,
        email_str
    ]
    return "|".join(parts)

async def login_and_setup_account(username: str, password: str, email: str, email_password: str, proxy: Optional[str] = None, bio_text: Optional[str] = None, profile_image_url: Optional[str] = None) -> Dict:
    """Login to account using instagrapi, set bio and profile picture, then return account data"""
    if not INSTAGRAPI_AVAILABLE:
        print("⚠️ instagrapi not available, skipping login")
        return {"status": "error", "message": "instagrapi not available"}
    
    try:
        cl = Client()
        session_path = session_file_for(username)
        
        # Set proxy if provided
        if proxy:
            try:
                cl.set_proxy(proxy)
                print(f"🔗 Using proxy for login: {proxy[:50]}...")
            except Exception as e:
                print(f"⚠️ Failed to set proxy: {e}")
        
        # Track challenge attempts to prevent infinite loop
        challenge_attempts = {"count": 0}
        challenge_suspended = {"value": False}  # Track if challenge resulted in suspension
        max_challenge_attempts = 2  # Only try challenge twice
        
        # Set up challenge handler for email verification
        # When instagrapi calls this handler, Instagram has already been requested to send the code
        def challenge_code_handler(insta_username, choice):
            # Check if we've already exceeded max attempts (silently return False to prevent repeated messages)
            if challenge_attempts["count"] >= max_challenge_attempts:
                # Already exceeded max attempts - silently return False (instagrapi may call this multiple times)
                return False
            
            challenge_attempts["count"] += 1
            
            if choice == ChallengeChoice.EMAIL:
                print(f"[DEBUG] Challenge via EMAIL (attempt {challenge_attempts['count']}/{max_challenge_attempts})")
                print(f"[DEBUG] 📧 Instagram will send a NEW verification code to {email} for login challenge...")
                print(f"[DEBUG] ⏳ Waiting for NEW challenge email (this is different from the email recovery code)...")
                
                # Instagram sends a NEW email when challenge is triggered for login
                # This is a different email from the email recovery confirmation email
                # Record when challenge started so we only look for emails AFTER this time
                import time
                challenge_start_time = time.time()  # Record when challenge started
                time.sleep(10)  # Wait 10 seconds for NEW email to arrive (Instagram may take time)
                
                # Try to get the NEW code with aggressive polling
                # Only look for emails that arrived AFTER the challenge started (to avoid old recovery email)
                code = get_verification_code_for_challenge(email, email_password, max_wait=60, min_timestamp=challenge_start_time)
                if code:
                    print(f"[DEBUG] ✅ NEW challenge code retrieved: {code}")
                    return code
                else:
                    print(f"[DEBUG] ❌ Failed to retrieve NEW challenge code (attempt {challenge_attempts['count']}/{max_challenge_attempts})")
                    if challenge_attempts["count"] >= max_challenge_attempts:
                        # Only print once when we reach max attempts
                        if not challenge_suspended["value"]:
                            print(f"[DEBUG] 🛑 Max challenge attempts ({max_challenge_attempts}) reached, skipping login")
                            challenge_suspended["value"] = True
                    return False
            elif choice == ChallengeChoice.SMS:
                print(f"📱 Challenge via SMS for {insta_username} - SMS not supported, only EMAIL")
                return False
            return False
        
        cl.challenge_code_handler = challenge_code_handler
        
        # Login with timeout - wrap in asyncio to make it cancellable
        print(f"[DEBUG] Logging in to {username}...")
        try:
            # Run login in executor to make it cancellable and non-blocking
            loop = asyncio.get_event_loop()
            await asyncio.wait_for(
                loop.run_in_executor(None, lambda: cl.login(username, password)),
                timeout=90  # 90 second timeout for login
            )
            print(f"[DEBUG] ✅ Login successful")
        except asyncio.TimeoutError:
            print(f"[DEBUG] ❌ Login timeout (90s)")
            raise Exception("Login timeout - no response within 90 seconds")
        except Exception as login_error:
            error_msg = str(login_error).lower()
            # Check if challenge handler marked as suspended (no code received)
            if challenge_suspended["value"]:
                print(f"⚠️ Login failed - challenge verification required but no code received")
                print(f"⏭️ Skipping login and continuing with account creation")
                return {
                    "status": "suspended",
                    "message": "Login failed - challenge verification required but no code received",
                    "suspended_reason": "No email verification code received"
                }
            # Check if challenge/verification error (but code was attempted)
            elif "challenge" in error_msg or "verification" in error_msg:
                print(f"⚠️ Login failed - challenge verification required but code not found")
                print(f"⏭️ Skipping login and continuing with account creation")
                return {
                    "status": "suspended",
                    "message": "Login failed - challenge verification required but no code received",
                    "suspended_reason": "Challenge required"
                }
            else:
                print(f"❌ Login failed: {login_error}")
                return {
                    "status": "error",
                    "message": f"Login failed: {str(login_error)}"
                }
        
        # Save session (run in executor to make it non-blocking)
        try:
            loop = asyncio.get_event_loop()
            await asyncio.wait_for(
                loop.run_in_executor(None, lambda: cl.dump_settings(session_path)),
                timeout=10  # 10 second timeout for session save
            )
        except Exception as e:
            print(f"⚠️ Failed to save session: {e}")
            # Continue anyway - session save is not critical
        
        # Get user info - try account_info() which is more reliable (run in executor to make it non-blocking)
        followers = None
        following = None
        ig_name = None
        bio = None
        instagram_id = None
        try:
            # Use account_info() which gets the logged-in user's own info
            loop = asyncio.get_event_loop()
            account_info = await asyncio.wait_for(
                loop.run_in_executor(None, lambda: cl.account_info()),
                timeout=20  # 20 second timeout for user info
            )
            if account_info:
                followers = account_info.follower_count if hasattr(account_info, 'follower_count') else None
                following = account_info.following_count if hasattr(account_info, 'following_count') else None
                ig_name = account_info.full_name if hasattr(account_info, 'full_name') else None
                bio = account_info.biography if hasattr(account_info, 'biography') else None
                instagram_id = str(account_info.pk) if hasattr(account_info, 'pk') else None
        except asyncio.TimeoutError:
            print(f"⚠️ User info fetch timeout (20s)")
            # Continue without user info - it's optional
        except Exception as e:
            print(f"⚠️ Could not fetch user info: {e}")
            # Continue without user info - it's optional
        
        # Set bio if provided (run in executor to make it non-blocking)
        if bio_text:
            try:
                print(f"[DEBUG] Setting bio...")
                try:
                    # Run in executor to make it non-blocking and cancellable
                    loop = asyncio.get_event_loop()
                    await asyncio.wait_for(
                        loop.run_in_executor(None, lambda: cl.account_edit(biography=bio_text)),
                        timeout=30  # 30 second timeout for bio setting
                    )
                    print(f"[DEBUG] ✅ Bio set")
                except asyncio.TimeoutError:
                    print(f"[DEBUG] ❌ Bio setting timeout (30s)")
                    # Don't raise - continue even if bio fails
                except Exception as bio_error:
                    print(f"[DEBUG] ❌ Failed to set bio: {bio_error}")
                    # Don't raise - continue even if bio fails
            except asyncio.CancelledError:
                print(f"[DEBUG] ⚠️ Bio setting cancelled")
                raise
            except Exception as e:
                print(f"[DEBUG] ❌ Failed to set bio: {e}")
                # Don't raise - continue even if bio fails
        
        # Set profile picture if provided
        if profile_image_url:
            try:
                print(f"[DEBUG] Setting profile picture...")
                # Download image with timeout
                try:
                    img_response = requests.get(profile_image_url, timeout=30)
                except requests.exceptions.Timeout:
                    print(f"[DEBUG] ❌ Image download timeout (30s)")
                    raise
                except requests.exceptions.RequestException as e:
                    print(f"[DEBUG] ❌ Image download error: {e}")
                    raise
                
                if img_response.status_code == 200:
                    # Save to temp file
                    import tempfile
                    with tempfile.NamedTemporaryFile(delete=False, suffix='.jpg') as tmp_file:
                        tmp_file.write(img_response.content)
                        tmp_path = tmp_file.name
                    
                    try:
                        # Set profile picture with timeout protection (run in executor to make it non-blocking)
                        loop = asyncio.get_event_loop()
                        await asyncio.wait_for(
                            loop.run_in_executor(None, lambda: cl.account_change_picture(tmp_path)),
                            timeout=45  # 45 second timeout for profile picture upload
                        )
                        print(f"[DEBUG] ✅ Profile picture set")
                    except asyncio.TimeoutError:
                        print(f"[DEBUG] ❌ Profile picture upload timeout (45s)")
                        raise
                    except Exception as pic_error:
                        print(f"[DEBUG] ❌ Failed to upload profile picture: {pic_error}")
                        raise
                    finally:
                        if os.path.exists(tmp_path):
                            try:
                                os.unlink(tmp_path)
                            except:
                                pass
                else:
                    print(f"[DEBUG] ❌ Failed to download image: HTTP {img_response.status_code}")
            except asyncio.CancelledError:
                print(f"[DEBUG] ⚠️ Profile picture setting cancelled")
                raise
            except Exception as e:
                print(f"[DEBUG] ❌ Failed to set profile picture: {e}")
        
        # Get session data
        settings = cl.get_settings()
        user_agent = settings.get("user_agent", "") if isinstance(settings, dict) else ""
        
        return {
            "status": "ok",
            "session_file": session_path,
            "session_data": settings,
            "user_agent": user_agent,
            "followers": followers,
            "following": following,
            "ig_name": ig_name,
            "bio": bio,
            "instagram_id": instagram_id,
        }
    except Exception as e:
        print(f"❌ Login error for {username}: {e}")
        return {"status": "error", "message": str(e)}

async def save_account_to_supabase(username: str, password: str, email: str, email_password: str, proxy: Optional[str] = None, session_data: Optional[Dict] = None, user_agent: str = "", followers: Optional[int] = None, following: Optional[int] = None, ig_name: Optional[str] = None, bio: Optional[str] = None, instagram_id: Optional[str] = None, tag: Optional[str] = None, login_status: str = "ok", login_message: Optional[str] = None, suspended_reason: Optional[str] = None, mobile: Optional[str] = None, creation_proxy: Optional[str] = None, creation_country: Optional[str] = None, session_id: Optional[str] = None) -> Dict:
    """Save account to Supabase with specified tag (default: 'cyber scraping')
    
    Args:
        login_status: "ok", "error", or "suspended"
        login_message: Error message if login failed
        suspended_reason: Reason for suspension (e.g., "No email verification code received", "Challenge required")
    """
    if not SUPABASE_AVAILABLE:
        print("⚠️ Supabase not available, skipping database save")
        return {"success": False, "message": "Supabase not available"}
    
    try:
        account_id = generate_random_id(15)
        workflow_id = generate_workflow_id(15)
        current_timestamp = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        
        # Generate account_string if session_data available
        account_string_value = ""
        if session_data:
            cookies = ""
            account_string_value = generate_account_string(username, password, session_data, user_agent, cookies, proxy, email, email_password)
        
        # Extract session_id and user_id from session_data (or use provided session_id)
        extracted_session_id = session_id  # Use provided session_id if available
        user_id = None
        if not extracted_session_id and session_data:
            # Fall back to extracting from session_data if not provided
            auth_data = session_data.get("authorization_data", {})
            extracted_session_id = auth_data.get("sessionid", "")
            user_id = auth_data.get("ds_user_id", "")
            # If user_id is numeric (Instagram ID), set to None for UUID field
            if user_id and isinstance(user_id, str) and user_id.isdigit():
                user_id = None
        
        # Determine account status based on login_status
        is_suspended = login_status == "suspended"
        active = "true" if login_status == "ok" else "false"
        logged_in = "true" if login_status == "ok" else "false"
        suspended_date = current_timestamp if is_suspended else None
        
        # Generate notes based on status
        if login_status == "ok":
            notes = f"✅ Account created and logged in on {current_timestamp} - Account credentials verified and working"
        elif is_suspended:
            if suspended_reason == "No email verification code received":
                notes = f"🚫 Account suspended on {current_timestamp} - No email verification code received within 35 seconds"
            elif suspended_reason == "Challenge required":
                notes = f"🚫 Account suspended on {current_timestamp} - Challenge verification required but no code received"
            else:
                notes = f"🚫 Account suspended on {current_timestamp} - {login_message or suspended_reason or 'Login failed'}"
        else:
            notes = f"❌ Account created but login failed on {current_timestamp} - {login_message or 'Login error'}"
        
        account_data = {
            "id": account_id,
            "name": username,
            "type": "outreach",
            "created_at": current_timestamp,
            "updated_at": current_timestamp,
            "is_managed": True,
            "workflow_id": workflow_id,
            "password": email_password if email_password else None,
            "verification_code": None,
            "ig_username": username,
            "ig_password": password,
            "active": active,
            "adspower_id": None,
            "notes": notes,
            "logged_in": logged_in,
            "avatar": None,
            "tag": tag if tag else tag_global if tag_global else "cyber scraping",
            "session_id": extracted_session_id if extracted_session_id else None,
            "user_id": user_id if user_id else None,
            "qualifying_tracking": None,
            "proxy_id": None,  # proxy_id should be integer ID, not URL string - set to None
            "delete_request": False,
            "deleted": False,
            "account_string": account_string_value if account_string_value else None,
            "upload_log_id": None,
            "previous_campaign": None,
            "price_per_account": 0.0,
            "ufac_complete": False,
            "adspower_configuration": None,
            "suspended_date": suspended_date if suspended_date else None,
            "deleted_date": None,
            "two_factor": None,
            "log": None,
            "followers": followers if followers else 0,
            "following": following if following else 0,
            "ig_name": ig_name if ig_name else None,
            "bio": bio if bio else None,
            "instagram_id": instagram_id if instagram_id else None,
            "mobile": mobile if mobile else None,  # Phone number used for account generation
            "creation_proxy": creation_proxy if creation_proxy else None,  # Proxy used for account creation
            "creation_country": creation_country if creation_country else None,  # Country of the proxy
        }
        
        # Upsert to Supabase
        existing = supabase.table("accounts").select("ig_username").eq("ig_username", username).execute()
        if existing.data and len(existing.data) > 0:
            response = supabase.table("accounts").update(account_data).eq("ig_username", username).execute()
        else:
            response = supabase.table("accounts").insert(account_data).execute()
        
        if response.data:
            print(f"✅ Saved account {username} to Supabase")
            return {"success": True, "message": "Account saved to Supabase"}
        else:
            print(f"❌ Failed to save account {username} to Supabase")
            return {"success": False, "message": "No data returned from Supabase"}
    except Exception as e:
        print(f"❌ Error saving account to Supabase: {e}")
        return {"success": False, "message": str(e)}

async def create_account():
    """Main account creation function"""
    global proxies
    
    # Generate fresh device info for this account
    generate_fresh_device_info()
    
    # Use the core account creation logic (which will handle proxy rotation)
    return await create_account_logic()
    
    # Get phone number from SMS-Activate
    activation_id, phone_number = get_number()
    if not activation_id or not phone_number:
        print("❌ Failed to get phone number from SMS-Activate!")
        return False
    
    try:
        # Check phone number
        current_ip = get_current_ip()
        data = {
            'signed_body': 'SIGNATURE.{"phone_id":"'+Family_ID+'","login_nonce_map":"{}","phone_number":"'+phone_number+'","guid":"'+Device_ID+'","device_id":"' + Android_ID + '","prefill_shown":"False"}',
        }
        response = requests.post(
            'https://i.instagram.com/api/v1/accounts/check_phone_number/', 
            headers=get_mobile_headers(), 
            data=data,
            proxies=current_proxy,
            timeout=30,
            verify=False
        ).text
        print(f"📱 Phone check response: {response}")
        
        # Send SMS code
        current_ip = get_current_ip()
        print(f"🌐 Sending SMS from IP: {current_ip}")
        data = {
            'signed_body': 'SIGNATURE.{"phone_id":"' + Family_ID + '","phone_number":"' + phone_number + '","guid":"' + Device_ID + '","device_id":"' + Android_ID + '","android_build_type":"release","waterfall_id":"' + water + '"}',
        }
        res = requests.post('https://i.instagram.com/api/v1/accounts/send_signup_sms_code/',
                            headers=get_mobile_headers(), 
                            data=data,
                            proxies=current_proxy,
                            timeout=30,
                            verify=False
        ).text
        print(f"📤 SMS send response: {res}")
        
        # Get SMS code from SMS-Activate
        sms_code = await get_sms_code(activation_id)
        if not sms_code:
            print("❌ Failed to get SMS code!")
            cancel_activation(activation_id)
            return False
        
        # Validate SMS code
        current_ip = get_current_ip()
        print(f"🌐 Validating SMS code from IP: {current_ip}")
        data = {
            'signed_body': 'SIGNATURE.{"verification_code":"'+sms_code+'","phone_number":"'+phone_number+'","guid":"'+Device_ID+'","device_id":"' + Android_ID + '","waterfall_id":"'+water+'"}',
        }
        validation_response = requests.post('https://i.instagram.com/api/v1/accounts/validate_signup_sms_code/',
                            headers=get_mobile_headers(), 
                            data=data,
                            proxies=current_proxy,
                            timeout=30,
                            verify=False
        ).text
        print(f"🔐 SMS validation response: {validation_response}")
        
        # Get username suggestions
        current_ip = get_current_ip()
        print(f"🌐 Getting username suggestions from IP: {current_ip}")
        # Generate fresh random username and real name for this account
        username = generate_random_username()
        real_name = generate_real_name()
        print(f"🎲 Generated username: {username}")
        print(f"👤 Generated real name: {real_name}")
        
        data = {
            'signed_body': 'SIGNATURE.{"phone_id":"'+Family_ID+'","guid":"'+Device_ID+'","name":"' + real_name + '","device_id":"' + Android_ID + '","email":"","waterfall_id":"'+water+'"}',
        }
        try:
            username_response = requests.post('https://i.instagram.com/api/v1/accounts/username_suggestions/',
                                headers=get_mobile_headers(), 
                                data=data,
                                proxies=current_proxy,
                                timeout=30,
                                verify=False
            ).json()
        except requests.exceptions.Timeout:
            print(f"[DEBUG] ❌ Username suggestions timeout (30s) - using generated username")
            username_response = {}
        except requests.exceptions.RequestException as e:
            print(f"[DEBUG] ❌ Username suggestions error: {e} - using generated username")
            username_response = {}
        
        if 'suggestions_with_metadata' in username_response:
            usname = username_response['suggestions_with_metadata']['suggestions'][0]['username']
        else:
            # Use the generated username directly (already has numbers)
            usname = username
        
        print(f'👤 Username: {usname}')
        
        # Generate fresh password for each account
        password = generate_password()
        print(f'🔑 Password: {password}')
        
        # Create account
        current_ip = get_current_ip()
        timpp = int(datetime.now().timestamp())
        data = {
            'signed_body': 'SIGNATURE.{"is_secondary_account_creation":"false","jazoest":"' + jazoest + '","tos_version":"row","suggestedUsername":"","verification_code":"'+str(sms_code)+'","sn_result":"API_ERROR: class X.2mY:7: ","do_not_auto_login_if_credentials_match":"true","phone_id":"'+Family_ID+'","enc_password":"#PWD_INSTAGRAM:0:'+str(timpp)+':' + password + '","phone_number":"'+str(phone_number)+'","email":"","username":"'+str(usname)+'","first_name":"'+real_name+'","day":"' + birth[0] + '","adid":"'+adid+'","guid":"'+Device_ID+'","year":"' + birth[1] + '","device_id":"' + Android_ID + '","_uuid":"'+Device_ID+'","month":"' + birth[2] + '","sn_nonce":"","force_sign_up_code":"","waterfall_id":"'+water+'","qs_stamp":"","has_sms_consent":"true","one_tap_opt_in":"true"}',
        }
        response = requests.post(
            'https://i.instagram.com/api/v1/accounts/create_validated/', 
            headers=get_mobile_headers(), 
            data=data,
            proxies=current_proxy,
            timeout=45,
            verify=False
        )
        
        print(f"🎯 Account creation response: {response.text}")
        
        if 'account_created":true' in response.text:
            print('✅ Account Created Successfully!')
            
            # Extract token from response headers to maintain session
            session_token = None
            if 'ig-set-authorization' in response.headers:
                session_token = response.headers['ig-set-authorization']
                print(f"🔑 Session token obtained: {session_token[:20]}...")
                # Save globally for subsequent authenticated actions
                try:
                    global current_session_token
                    current_session_token = session_token
                except NameError:
                    pass
            
            # Get recovery email for SMS account
            recovery_email = get_available_email()
            if recovery_email:
                print(f"📧 Adding recovery email: {recovery_email}")
                # Add email recovery to the account using the session
                add_email_recovery_to_sms_account(usname, password, phone_number, recovery_email, session_token)
            
            # Save to files with new format: username:pass:email:emailpassword
            if recovery_email:
                with open('accounts.txt', 'a') as f:
                    f.write(f'{usname}:{password}:{recovery_email}:{EMAIL_PASSWORD}\n')
            else:
                with open('accounts.txt', 'a') as f:
                    f.write(f'{usname}:{password}:{phone_number}:{session_token}\n')
            
            with open('phone_numbers.txt', 'a') as f:
                f.write(f'{usname}:{phone_number}:{password}\n')
            
                return True
        else:
            print(f"❌ Account creation failed: {response.text}")
            return False
            
    except Exception as e:
        print(f"❌ Error during account creation: {e}")
        return False

def sleep_jitter(base_min=1, base_max=3):
    try:
        time.sleep(random.uniform(base_min, base_max))
    except Exception:
        pass

if __name__ == "__main__":
    print("🚀 Starting Instagram Account Creator")
    print("=" * 60)
    
    # Check if UserAgent.txt exists
    if not os.path.exists("UserAgent.txt"):
        print("⚠️ UserAgent.txt not found, using fallback user agent")
    
    # Ask user for proxy usage
    proxy_choice = input("\n🌐 Do you want to use proxies? (y/n): ").strip().lower()
    use_proxies = proxy_choice == 'y'
    
    if use_proxies:
        print("✅ Proxy usage enabled")
    else:
        print("❌ Proxy usage disabled")
    
    # Ask user for async concurrency
    async_choice = input("\n🧵 Do you want to use async concurrency? (y/n): ").strip().lower()
    use_async = async_choice == 'y'
    
    if use_async:
        max_tasks = int(input("🔢 Enter max concurrent tasks (1-10): ").strip() or "3")
        max_tasks = max(1, min(MAX_THREADS, max_tasks))
        print(f"✅ Async concurrency enabled with {max_tasks} tasks")
    else:
        print("❌ Async concurrency disabled")
    
    # SMS verification mode (only option)
        print(f"📊 Will continuously create accounts (new phone numbers will be obtained automatically)")
        
        success_count = 0
        fail_count = 0
        account_counter = 0
        running = False
        
        if use_async:
            # Async mode for SMS - continuous loop
            print(f"🧵 Starting continuous async SMS processing with {max_tasks} tasks...")
            
            async def run_async_sms_processing():
                global success_count, fail_count, account_counter, running
                running = True
                tasks = []
                try:
                    while running:
                        # Keep submitting new tasks as previous ones complete
                        while len(tasks) < max_tasks and running:
                            account_counter += 1
                            task = asyncio.create_task(create_single_sms_account(account_counter, None))
                            tasks.append(task)
                        
                        # Process completed tasks
                        done = set()
                        if tasks:
                            done, pending = await asyncio.wait(tasks, return_when=asyncio.FIRST_COMPLETED)
                            for task in done:
                                try:
                                    success, account_name = await task
                                    if success:
                                        success_count += 1
                                    else:
                                        fail_count += 1
                                except Exception as e:
                                    fail_count += 1
                            tasks = list(pending)
                        
                        # Wait before checking for new tasks
                        if done:
                            wait_time = random.randint(10, 20)
                            await asyncio.sleep(wait_time)
                        else:
                            await asyncio.sleep(2)  # Short wait if no tasks completed
                            
                except KeyboardInterrupt:
                    print(f"\n\n🛑 Stopped by user (Ctrl+C)")
                    print(f"📊 Stopping all tasks...")
                    running = False
                    # Cancel all pending tasks
                    for task in tasks:
                        task.cancel()
                    # Wait for tasks to finish cancelling
                    await asyncio.gather(*tasks, return_exceptions=True)
            
            # Run async processing
            try:
                asyncio.run(run_async_sms_processing())
            except KeyboardInterrupt:
                            pass
        else:
            # Sequential mode for SMS - continuous loop
            while True:
                try:
                    account_counter += 1
                    
                    # Sequential mode - run in async context
                    import asyncio
                    result = asyncio.run(create_account())
                    if result:
                        success_count += 1
                    else:
                        fail_count += 1
                    
                    # Wait before next account
                    try:
                        wait_time = random.randint(30, 60)
                        time.sleep(wait_time)
                    except KeyboardInterrupt:
                        raise
                    
                except KeyboardInterrupt:
                    print(f"\n\n🛑 Stopped by user (Ctrl+C)")
                    break
                except Exception as e:
                    print(f"❌ Unexpected error: {e}")
                    fail_count += 1
                    time.sleep(10)
        
        print(f"\n📊 Final Stats: ✅ {success_count} successful | ❌ {fail_count} failed")

# FastAPI endpoints
@router.get("/")
async def root():
    """Root endpoint"""
    return {"message": "aqua instagram api - create account"}

async def run_account_creation_background(num_accounts: int, num_threads: int, use_proxies_flag: bool, country_code: str, first_name_variants: Optional[str], last_name_variants: Optional[str], username_variants: Optional[str], bio_variants: Optional[str], profile_image_url: Optional[str], tag: Optional[str]):
    """Background task to create accounts without blocking the API"""
    try:
        # Set up signal handler for immediate Ctrl+C cancellation
        import signal
        def signal_handler(sig, frame):
            print(f"\n[BACKGROUND] ❌ Received Ctrl+C - cancelling all tasks...")
            raise KeyboardInterrupt()
        
        # Register signal handler (only works in main thread, but helps with propagation)
        try:
            signal.signal(signal.SIGINT, signal_handler)
        except:
            pass  # May fail in background thread, that's okay
        # Set proxy usage globally
        global use_proxies, country_global
        use_proxies = use_proxies_flag
        country_global = country_code if country_code else "187"  # Default to USA if not provided
        
        # Parse and store variants globally
        global first_name_list, last_name_list, username_list, bio_list, profile_image_url_list, tag_global
        first_name_list = parse_variants(first_name_variants)
        last_name_list = parse_variants(last_name_variants)
        username_list = parse_variants(username_variants)
        bio_list = parse_variants(bio_variants)
        
        # Parse profile image URLs - support both single URL and multiple URLs (newline-separated)
        if profile_image_url:
            # Check if it contains newlines (multiple URLs) or is a single URL
            if '\n' in profile_image_url:
                # Multiple URLs provided (newline-separated)
                profile_image_url_list = parse_variants(profile_image_url)
            else:
                # Single URL provided
                profile_image_url_list = [profile_image_url.strip()]
        else:
            # No URLs provided
            profile_image_url_list = []
        
        tag_global = tag if tag else "cyber scraping"
        
        # Create accounts concurrently
        success_count = 0
        fail_count = 0
        tasks = []
        
        for i in range(num_accounts):
            try:
                # Check for cancellation before creating new task
                await asyncio.sleep(0)  # Yield to check for cancellation
                
                # Create task for account creation
                task = asyncio.create_task(create_single_sms_account(i + 1, None))
                tasks.append(task)
                
                # Limit concurrent tasks
                if len(tasks) >= num_threads:
                    # Wait for at least one task to complete (with cancellation support)
                    try:
                        done, pending = await asyncio.wait(tasks, return_when=asyncio.FIRST_COMPLETED)
                        for completed_task in done:
                            try:
                                success, account_name = await completed_task
                                if success:
                                    success_count += 1
                                else:
                                    fail_count += 1
                            except (asyncio.CancelledError, KeyboardInterrupt):
                                print(f"[BACKGROUND] ❌ Task cancelled by user")
                                fail_count += 1
                                raise  # Re-raise to cancel all tasks
                            except Exception as e:
                                print(f"❌ Error in task: {e}")
                                fail_count += 1
                        tasks = list(pending)  # Update tasks list with remaining tasks
                    except (asyncio.CancelledError, KeyboardInterrupt):
                        print(f"[BACKGROUND] ❌ Background task cancelled by user")
                        # Cancel all pending tasks
                        for t in tasks:
                            t.cancel()
                        raise
            except (asyncio.CancelledError, KeyboardInterrupt):
                print(f"[BACKGROUND] ❌ Account creation loop cancelled by user")
                # Cancel all pending tasks
                for t in tasks:
                    t.cancel()
                raise
            except Exception as e:
                print(f"[BACKGROUND] ❌ Error creating account task: {e}")
                fail_count += 1
                for t in tasks:
                    t.cancel()
                await asyncio.gather(*tasks, return_exceptions=True)
                break
        
        # Wait for remaining tasks
        if tasks:
            try:
                results = await asyncio.gather(*tasks, return_exceptions=True)
                for result in results:
                    if isinstance(result, (asyncio.CancelledError, KeyboardInterrupt)):
                        fail_count += 1
                    elif isinstance(result, Exception):
                        fail_count += 1
                    else:
                        success, account_name = result
                        if success:
                            success_count += 1
                        else:
                            fail_count += 1
            except (asyncio.CancelledError, KeyboardInterrupt):
                print(f"[BACKGROUND] ❌ Remaining tasks cancelled by user")
                for t in tasks:
                    t.cancel()
                await asyncio.gather(*tasks, return_exceptions=True)
                fail_count += len(tasks)
        
        print(f"[BACKGROUND] Account creation completed: ✅ {success_count} successful | ❌ {fail_count} failed")
    except (asyncio.CancelledError, KeyboardInterrupt):
        print(f"[BACKGROUND] ❌ Account creation cancelled by user (Ctrl+C)")
        # Cancel all tasks
        if 'tasks' in locals():
            for t in tasks:
                t.cancel()
            await asyncio.gather(*tasks, return_exceptions=True)
    except Exception as e:
        print(f"[BACKGROUND] ❌ Error in background account creation: {e}")
        import traceback
        traceback.print_exc()

@router.post("/create-account-sms")
async def create_account_sms_endpoint(request: SMSAccountRequest, background_tasks: BackgroundTasks):
    """Create Instagram accounts with SMS verification. Supports name/username/bio variants and custom profile image.
    
    Args:
        request: SMSAccountRequest with num_accounts, num_threads, use_proxies, and variant lists
    """
    try:
        # Validate inputs
        if request.num_accounts <= 0:
            raise HTTPException(status_code=400, detail="num_accounts must be greater than 0")
        if request.num_threads <= 0:
            raise HTTPException(status_code=400, detail="num_threads must be greater than 0")
        if request.num_threads > MAX_THREADS:
            request.num_threads = MAX_THREADS
        
        # Add background task - this returns immediately without blocking
        background_tasks.add_task(
            run_account_creation_background,
            request.num_accounts,
            request.num_threads,
            request.use_proxies,
            request.country if request.country else "187",
            request.first_name_variants,
            request.last_name_variants,
            request.username_variants,
            request.bio_variants,
            request.profile_image_url,
            request.tag
        )
        
        return {
            "success": True,
            "message": f"Account creation started in background. Creating {request.num_accounts} accounts with {request.num_threads} concurrent threads."
        }
    except HTTPException:
        raise  # Re-raise HTTP exceptions
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

